//
//  GMRtcManager.m
//  Gengmei
//
//  Created by 卢悦明 on 2020/2/18.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMRtcManager.h"
#import "GMFaceHeader.h"
@implementation GMRtcManager : NSObject

static id _manager;
+ (instancetype)sharedRtcManager
{
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        _manager = [[self alloc] init];
    });
    return _manager;
}

+(instancetype)allocWithZone:(struct _NSZone *)zone
{
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        _manager = [super allocWithZone:zone];
    });
    return _manager;
}

- (id)copyWithZone:(NSZone *)zone
{
    return _manager;
}

- (instancetype)init
{
    self = [super init];
    if (self) {
        
        _rtcEngine = [TTTRtcEngineKit sharedEngineWithAppId:TTTAppID delegate:nil];
        [_rtcEngine setSignalTimeout:30];
        _me = [[GMTTTUser alloc] initWith:0];
        _localProfile = TTTRtc_VideoProfile_Default;
        _cdnProfile = TTTRtc_VideoProfile_Default;
        // 杀死app 需要退出
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(closeRoom) name:@"gm_close_app" object:nil];
    }
    return self;
}


/// 注销直播间
- (void)closeExcitRoom {
    if (self.rtcEngine) {
        [self.rtcEngine leaveChannel:nil];
        [self.rtcEngine stopPreview];
    }
}

- (void)muteLocalAudioStream:(BOOL) status {
    self.me.mutedSelf = status;
    [self.rtcEngine muteLocalAudioStream:status];
}


- (void)switchCamera {
    [self.rtcEngine switchCamera];
}

#pragma mark - 设置合成视频位置信息
- (void)setTelephoneVideoCompositingLayout:(BOOL)windowStatus userId:(int64_t)userId doctorId:(int64_t)doctorId {
    _videoLayout = [[TTTRtcVideoCompositingLayout alloc] init];
    _videoLayout.canvasWidth = MAINSCREEN_WIDTH;
    _videoLayout.canvasHeight = MAINSCREEN_HEIGHT * 0.5;    
    [self videoWindowX:0 Y:0 Width:0.5 Height:1 zOrder:100 alpha:1 TTTRtcRenderMode:TTTRtc_Render_Adaptive uId:userId];
    [self videoWindowX:0.5 Y:0 Width:0.5 Height:1 zOrder:100 alpha:1 TTTRtcRenderMode:TTTRtc_Render_Adaptive uId:doctorId];
    [_rtcEngine setVideoCompositingLayout:_videoLayout];

    
}

- (TTTRtcVideoCompositingRegion *)videoWindowX:(double)x Y:(double)y Width:(double)w Height:(double)h zOrder:(NSInteger)zOrder alpha:(double)alpha TTTRtcRenderMode:(TTTRtcRenderMode)Type uId:(int64_t)uid {
    TTTRtcVideoCompositingRegion *anchorRegion = [[TTTRtcVideoCompositingRegion alloc] init];
    anchorRegion.uid = uid;
    anchorRegion.x = x;
    anchorRegion.y = y;
    anchorRegion.width = w;
    anchorRegion.height = h;
    anchorRegion.zOrder = zOrder;
    anchorRegion.alpha = alpha;
    anchorRegion.renderMode = Type;
    [_videoLayout.regions addObject:anchorRegion];
    return anchorRegion;
}

- (void)beautyStatus:(BOOL)status {
    if (status) {
        [self.rtcEngine setBeautyFaceStatus:YES beautyLevel:0.5 brightLevel:0.5];

    } else {
        [self.rtcEngine setBeautyFaceStatus:NO beautyLevel:0.0 brightLevel:0.0];
    }
}

#pragma mark - 杀死app
- (void)closeRoom {
    [GMVideoTelephoneRequestTool telephoneMessageEventType:GMEventType_zhuDongExit consultationRecordId:_consultationRecordId finishBlock:nil];
    [self closeExcitRoom];
}
@end
