//
//  GMVideoPhobos.m
//  Gengmei
//
//  Created by zhouLiang on 2020/3/17.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMVideoPhobos.h"
@import GMFoundation;
@import GMPhobos;
@import GMBase;

@implementation GMVideoPhobos
/**
 * 获取trace_id,只有第一个免费呼叫需要传
 */
+ (NSString *)getTraceId {
    NSString *str = [[GMVideoPhobos getDateTime] stringFromMD5];
    return str;
}
/**
 *  @brief 链路埋点
 *
 *  @param actionStep :  操作
 *  @param consultId  :  连线id
 *  @param traceId    :  连线前的id
 */
+ (void)video_monitoringWithActionStep:(NSString *)actionStep
                             consultId:(NSString *)consultId
                               traceId:(NSString *)traceId {
    [Phobos track:@"video_monitoring" attributes:@{@"trace_id":SafeString(traceId),
                                                   @"action_step":SafeString(actionStep),
                                                   @"consult_id":SafeString(consultId),
                                                   @"call_timestamp":SafeString([GMVideoPhobos getDateTime])}];
}
/**
 *  @brief 链路埋点
 *
 *  @param actionStep :  操作
 *  @param consultId  :  连线id
 *  @param taskId     :  抢单id
 */
+ (void)video_monitoringWithActionStep:(NSString *)actionStep
                             consultId:(NSString *)consultId
                                taskId:(NSString *)taskId {
    [Phobos track:@"video_monitoring" attributes:@{@"task_id":SafeString(taskId),
                                                   @"action_step":SafeString(actionStep),
                                                   @"consult_id":SafeString(consultId),
                                                   @"call_timestamp":SafeString([GMVideoPhobos getDateTime])}];
}

/**
 *  @brief channel_service
 *
 *  @param recordId :  连线记录ID(对应后端连线记录表record_id)
 *  @param channel  :  通道类型（1:网易云信信令 2:极光推送）
 *  @param channelId :  通道唯一标识(网易或极光服务推送ID,目前只有网易有)
 *  @param serviceType  :  服务类型(1:送达 2:拉起)
 */
+ (void)channel_serviceWithRecordId:(NSString *)recordId
                             channel:(NSInteger)channel
                                channelId:(NSString *)channelId
                        serviceType:(NSInteger)serviceType {
    [Phobos track:@"channel_service" attributes:@{@"record_id":SafeString(recordId),
                                                   @"channel":@(channel),
                                                   @"channel_id":SafeString(channelId),
                                                   @"service_type":@(serviceType),
                                                   @"backcall_create_time":SafeString([GMVideoPhobos getDateTime])}];
    
}
/**
* 获取毫秒级时间戳
*/
+ (NSString *)getDateTime {
    NSDate *datenow = [NSDate date];
    NSString *timeSp = [NSString stringWithFormat:@"%ld", (long)([datenow timeIntervalSince1970]*1000)];
    return timeSp;
}
@end
