//
//  GMVideoTelephoneRequestTool.m
//  Gengmei
//
//  Created by 卢悦明 on 2020/2/20.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMVideoTelephoneRequestTool.h"
#import "RequestHeader.h"
#import "GMLibraryHeader.h"

@implementation GMVideoTelephoneRequestTool

#pragma mark - 关注/取消关注
+ (void)followOrNot:(BOOL)status withUid:(NSString *)uid type:(NSString *)type finishBlock:(void (^)(BOOL success, NSString *message))finishBlock{
    NSDictionary *params = @{
        @"id": SafeString(uid),
        @"type":type
    };
    NSString *path = status ?@"/hybrid/user/add_follow/_data" : @"/hybrid/user/del_follow/_data";
    [GMNetworking requestOCWithApi:path method:GMHTTPMethodPost parameters:params completion:^(GMResponseOC * _Nonnull responseObject) {
        if (responseObject.isSuccess) {
            if (finishBlock) {
                finishBlock(YES, responseObject.message);
            }
            //更改医生主页的关注状态
            [[NSNotificationCenter defaultCenter] postNotificationName:@"changeFolllowCallbackName" object:@(status)];
        } else {
            if (finishBlock) {
                finishBlock(NO, responseObject.message);
            }
        }
    }];
}
#pragma mark - 用户呼出接口
+ (void)userVideoTelephoneMessage:(NSDictionary *)params finishBlock:(void (^)(BOOL success, NSDictionary *modelDict, NSString *errorMessage))finishBlock {
    
    [GMNetworking requestOCWithApi:API_LAUNCH_ONE2ONE method:GMHTTPMethodPost parameters:params completion:^(GMResponseOC * _Nonnull responseObject) {
        dispatch_async(dispatch_get_main_queue(), ^{
            
            if (responseObject.isSuccess) {
                if (finishBlock) {
                    NSDictionary *dict = [NSJSONSerialization JSONObjectWithData:responseObject.responseData options:NSJSONReadingMutableLeaves error:nil];
                    GMVideoTelephoneModel *model = [[GMVideoTelephoneModel alloc] initWithDictionary:dict[@"data"] error:nil];
                    finishBlock(YES, @{@"model":model}, responseObject.message);
                }
            } else {
                if (finishBlock) {
                    finishBlock(NO, nil,responseObject.message);
                }
            }
        });
    }];
}


#pragma mark - 医生接入接口
+ (void)doctorVideoTelephoneMessage:(NSDictionary *)params finishBlock:(void (^)(BOOL success, NSDictionary *modelDict, NSString *errorMessage))finishBlock {
    
    [GMNetworking requestOCWithApi:@"/api/consultation_counsel/get_consultation_record" method:GMHTTPMethodGet parameters:params completion:^(GMResponseOC * _Nonnull responseObject) {
        dispatch_async(dispatch_get_main_queue(), ^{
            
            if (responseObject.isSuccess) {
                if (finishBlock) {
                    NSDictionary *dict = [NSJSONSerialization JSONObjectWithData:responseObject.responseData options:NSJSONReadingMutableLeaves error:nil];
                    GMVideoTelephoneModel *model = [[GMVideoTelephoneModel alloc] initWithDictionary:dict[@"data"] error:nil];
                    finishBlock(YES, @{@"model":model},responseObject.message);
                }
            } else {
                if (finishBlock) {
                    finishBlock(NO, nil,responseObject.message);
                }
            }
        });
    }];
}

//视频通话流程事件上报
+ (void)telephoneMessageEventType:(GMEventType)eventType
             consultationRecordId:(NSString *)consultationRecordId
                      finishBlock:(void (^)(BOOL success, NSDictionary *message))finishBlock {
    if (consultationRecordId == nil) {
        return;
    }
    NSDictionary *params = @{
        @"event_type":[NSString stringWithFormat:@"%d", eventType],
        @"consultation_record_id":SafeString(consultationRecordId),
    };
    [GMNetworking requestOCWithApi:@"/api/consultation_counsel/report_event" method:GMHTTPMethodPost parameters:params completion:^(GMResponseOC * _Nonnull responseObject) {
         dispatch_async(dispatch_get_main_queue(), ^{
             
             if (responseObject.isSuccess) {
                 if (finishBlock) {
                     NSDictionary *dict = [NSJSONSerialization JSONObjectWithData:responseObject.responseData options:NSJSONReadingMutableLeaves error:nil];
                     GMTelphoneStatusModel *model = [[GMTelphoneStatusModel alloc] initWithDictionary:dict[@"data"] error:nil];
                     finishBlock(YES, @{@"model":model});
                 }
             } else {
                 if (finishBlock) {
                     if (eventType != 8) {
                         [GMHudModule showWarning:responseObject.message];
                     }
                     finishBlock(NO, @{@"message":responseObject.message});
                 }
            }

         });
        }];
}

#pragma mark - 用户端推荐美购列表
+ (void)userVideoTelephoneRecommodWelfare:(NSDictionary *)params finished:(void (^)(BOOL success, NSMutableArray *dataArray))finishBlock {
    [GMNetworking requestOCWithApi:@"/api/consultation_counsel/get_recommended_bag" method:GMHTTPMethodGet parameters:params completion:^(GMResponseOC * _Nonnull responseObject) {
        dispatch_async(dispatch_get_main_queue(), ^{
            
            if (responseObject.isSuccess) {
                if (finishBlock) {
                    NSDictionary *dict = [NSJSONSerialization JSONObjectWithData:responseObject.responseData options:NSJSONReadingMutableLeaves error:nil];
                    NSDictionary *data = dict[@"data"];
                    NSArray *array = data[@"services"];
                    NSMutableArray *resultArray = [GMTelephoneRecommodWelfareModel arrayOfModelsFromDictionaries:array error:nil];
                    finishBlock(YES, resultArray);
                }
            } else {
                if (finishBlock) {
                    finishBlock(NO, nil);
                }
            }
        });
    }];
}
@end
