//
//  GMVideoTelephoneModel.h
//  Gengmei
//
//  Created by 卢悦明 on 2020/3/6.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "GMUserInfoModel.h"
#import "GMConsultationInfoModel.h"
@import GMBase;

@class GMTelephoneDoctorModel;
NS_ASSUME_NONNULL_BEGIN

@protocol GMNeteaseIMModel @end
@interface GMNeteaseIMModel : GMObject
/// 被叫方的account_id，可能是空字符串
@property (nonatomic, copy) NSString *toAccountId;

/// 双方需要加入的信令房间id，可能是空字符串
@property (nonatomic, copy) NSString *channelId;
/// 额外参数
@property (nonatomic, copy) NSString *inviteExt;


@end
@interface GMVideoTelephoneModel : GMObject

/// 面诊记录id
@property (nonatomic, strong) NSString *consultationRecordId;

/// 发起用户ID
@property (nonatomic, strong) NSString *userId;

/// 性别
@property (nonatomic, strong) NSString *userGender;

/// 发起用户年龄
@property (nonatomic, strong) NSString *userAge;

/// 是否做过医美
@property (nonatomic, strong) NSString *userHasAestheticMedicine;

/// 想要咨询的项目(部位)列表
@property (nonatomic, strong) NSArray *userTargetProject;

@property (nonatomic, strong) NSString *referer;
/// 来源
@property (nonatomic, strong) NSString *refererText;
/// 房间id
@property (nonatomic, strong) NSString *channelId;
/// 推流地址
@property (nonatomic, strong) NSString *streamUrl;
@property (nonatomic, strong) GMUserInfoModel *userInfo;
@property (nonatomic, strong) GMConsultationInfoModel *counsellorInfo;
// 网易云信
@property (nonatomic, strong) GMNeteaseIMModel *neteaseIm;
/// 加入房间重试次数，大于等于0，0代表不重试
@property (nonatomic, assign) NSInteger joinChannelRetryCount;

/// 重试间隔，毫秒，大于等于0
@property (nonatomic, assign) NSInteger joinChannelRetryMs;


/// 获取性别字符串
+ (NSString *)userGenderStr:(GMVideoTelephoneModel *)model;

/// 咨询内容
+ (NSString *)zixunName:(GMVideoTelephoneModel *)model;

/// 描述
/// @param model 女 | 22岁 | 做过医美
+ (NSString *)detialStr:(GMVideoTelephoneModel *)model;
@end

NS_ASSUME_NONNULL_END

