//
//  GMDoctorShoppingViewCell.m
//  Gengmei
//
//  Created by 刘鹿杰的mac on 2020/2/24.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMDoctorShoppingViewCell.h"
#import "GMRecommendShopingModel.h"

@interface GMDoctorShoppingViewCell ()

@property (nonatomic, strong) GMButton *seleBtn;
@property (nonatomic, strong) UIImageView *iconImage;
@property (nonatomic, strong) GMLabel *titleLabel;
@property (nonatomic, strong) UILabel *priceLabel;
@property (nonatomic, strong) GMLabel *buyNumLabel;

@end
 
@implementation GMDoctorShoppingViewCell

-(void)setup {
    [super setup];
    self.bottomLine.hidden = YES;
    self.iconImage = [[UIImageView alloc] init];
    _iconImage.layer.masksToBounds = YES;
    _iconImage.layer.cornerRadius = 2;
    [self addSubview:_iconImage];
    
    self.titleLabel = [[GMLabel alloc] init];
    _titleLabel.textColor = UIColor.bodyText;
    _titleLabel.font = [UIFont gmBoldFont:16];
    _titleLabel.textAlignment = NSTextAlignmentLeft;
    _titleLabel.numberOfLines = 2;
    [self addSubview:_titleLabel];
    
    self.priceLabel = [[UILabel alloc] init];
    self.priceLabel.font = [UIFont boldSystemFontOfSize:20];
    self.priceLabel.textColor = RGBCOLOR_HEX(0xFF5963);
    _priceLabel.textAlignment = NSTextAlignmentLeft;
    [self addSubview:_priceLabel];
    
    self.buyNumLabel = [GMLabel labelWithTextColor:UIColor.auxiliaryTextDark fontSize:12];
    _buyNumLabel.textAlignment = NSTextAlignmentRight;
    [self addSubview:_buyNumLabel];
    
    UILabel *bottomLine = [[UILabel alloc] init];
    bottomLine.backgroundColor = RGBCOLOR_HEX(0xe2e2e2);
    [self addSubview:bottomLine];
    [bottomLine mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.mas_left).offset(16);
        make.right.equalTo(self.mas_right).offset(-16);
        make.height.mas_equalTo(0.35);
        make.bottom.equalTo(self.mas_bottom);
    }];
}

-(void)updateConstraints {
    [super updateConstraints];
    [_iconImage mas_updateConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(15);
        make.width.height.mas_equalTo(80);
        make.left.mas_equalTo(15);
    }];
    [_titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(_iconImage.mas_top);
        make.left.mas_equalTo(_iconImage.mas_right).offset(10);
        make.right.mas_equalTo(-22);
    }];
    
    [_priceLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(_titleLabel.mas_left);
        make.right.mas_equalTo(_titleLabel.mas_right);
        make.bottom.mas_equalTo(_iconImage.mas_bottom);
        make.height.mas_equalTo(24);
    }];
    
    [_buyNumLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.mas_equalTo(-22);
        make.bottom.mas_equalTo(_priceLabel.mas_bottom);
        make.height.mas_equalTo(12);
    }];
}

-(void)setListModel:(GMRecommendShopingModel *)listModel {
    _listModel = listModel;
    self.titleLabel.text = listModel.shortDescription;
    [self.iconImage sd_setImageWithURL:[NSURL URLWithString:listModel.image]];
    NSString *price = [NSString stringWithFormat:@"¥ %@", listModel.gengmeiPrice];
    NSMutableAttributedString *attr = [[NSMutableAttributedString alloc] initWithString:price];
    [attr addAttribute:NSFontAttributeName value:[UIFont systemFontOfSize:14] range:NSMakeRange(0, 1)];
    self.priceLabel.attributedText = attr;
    self.buyNumLabel.text = listModel.sellOrDiaryNumDesc;
}

@end
