//
//  GMTelephoneAttentionView.m
//  Gengmei
//
//  Created by 卢悦明 on 2020/2/21.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMTelephoneAttentionView.h"
#import "GMLibraryHeader.h"

@implementation GMTelephoneAttentionView
{
    UIView *_iconBackView;
    UIImageView *_iconImage;
    UILabel *_nameLabel;
    UIImageView *_backImg;
}

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setupUI];
    }
    return self;
}

- (void)setupUI {
    
    _iconBackView = [[UIView alloc] init];
    _iconBackView.backgroundColor = UIColor.whiteColor;
    _iconBackView.layer.masksToBounds = YES;
    _iconBackView.layer.cornerRadius = 25;
    [self addSubview:_iconBackView];
    [_iconBackView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(50, 50));
        make.left.equalTo(self.mas_left);
        make.centerY.equalTo(self.mas_centerY);
    }];
    
    _iconImage = [[UIImageView alloc] init];
    _iconImage.layer.masksToBounds = YES;
    _iconImage.layer.cornerRadius = 24;
    [self addSubview:_iconImage];
    [_iconImage mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(48, 48));
        make.centerX.equalTo(_iconBackView.mas_centerX);
        make.centerY.equalTo(_iconBackView.mas_centerY);
    }];
    
    _nameLabel = [[UILabel alloc] init];
    _nameLabel.textColor = UIColor.whiteColor;
    _nameLabel.font = [UIFont systemFontOfSize:12];
    _nameLabel.textAlignment = NSTextAlignmentLeft;
    [self addSubview:_nameLabel];
    
    [_nameLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(_iconImage.mas_right).offset(5);
        make.bottom.equalTo(_iconImage.mas_bottom);
        make.height.mas_equalTo(@(32));
        make.width.lessThanOrEqualTo(@(70));
    }];
    
    _guanZhuBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    _guanZhuBtn.hidden = YES;
    [_guanZhuBtn setTitle:@"关注" forState:UIControlStateNormal];
    [_guanZhuBtn setTitle:@"已关注" forState:UIControlStateSelected];
    [_guanZhuBtn setBackgroundImage:[UIImage imageNamed:@"telephone_guanzhu"] forState:UIControlStateNormal];
    [_guanZhuBtn setBackgroundImage:[UIImage imageNamed:@"telephone_quxiao"] forState:UIControlStateSelected];
    [_guanZhuBtn addTarget:self action:@selector(clickGuan:) forControlEvents:UIControlEventTouchUpInside];
    [_guanZhuBtn setTitleColor:RGBCOLOR_HEX(0x4DBBB5) forState:UIControlStateNormal];
    [_guanZhuBtn setTitleColor:[UIColor whiteColor] forState:UIControlStateSelected];
    _guanZhuBtn.hidden = YES;
    _guanZhuBtn.titleLabel.font = [UIFont systemFontOfSize:10];
    [self addSubview:_guanZhuBtn];
    [_guanZhuBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(_nameLabel.mas_right).offset(5);
        make.centerY.equalTo(_nameLabel.mas_centerY);
        make.size.mas_equalTo(CGSizeMake(40, 22));
    }];
    
    _backImg = [[UIImageView alloc] init];
    _backImg.image = [UIImage imageNamed:@"telephone_backguanzhu"];
    [self insertSubview:_backImg atIndex:0];
    [_backImg mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(_iconBackView.mas_right).offset(-20);
        make.height.equalTo(@(32));
        make.right.equalTo(_guanZhuBtn.mas_right).offset(8);
        make.bottom.equalTo(_nameLabel.mas_bottom);
    }];
}

- (void)setModel:(GMVideoTelephoneModel *)model {
    _model = model;
    [_iconImage sd_setImageWithURL:[NSURL URLWithString: model.counsellorInfo.portrait]];
    _nameLabel.text = _model.counsellorInfo.name;
    [self layoutGuanZhu:_model.counsellorInfo.isFollow];
}

- (void)clickGuan:(UIButton *)sender {
    sender.selected = !sender.selected;
    [self layoutGuanZhu:sender.selected];

    if ([self.delegate respondsToSelector:@selector(clickGuanZhu:)]) {
        [self.delegate clickGuanZhu:sender.selected];
    }
}

- (void)layoutGuanZhu:(BOOL)status {
    _guanZhuBtn.hidden =  status;
    if (status) {//隐藏
        [_guanZhuBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(_nameLabel.mas_right).offset(5);
            make.centerY.equalTo(_nameLabel.mas_centerY);
            make.size.mas_equalTo(CGSizeMake(0, 22));
        }];
        [_backImg mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(_iconBackView.mas_right).offset(-20);
            make.height.equalTo(@(32));
            make.right.equalTo(_nameLabel.mas_right).offset(8);
            make.bottom.equalTo(_nameLabel.mas_bottom);
        }];
    } else { //显示
        [_guanZhuBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(_nameLabel.mas_right).offset(5);
            make.centerY.equalTo(_nameLabel.mas_centerY);
            make.size.mas_equalTo(CGSizeMake(40, 22));
        }];
        [_backImg mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(_iconBackView.mas_right).offset(-20);
            make.height.equalTo(@(32));
            make.right.equalTo(_guanZhuBtn.mas_right).offset(8);
            make.bottom.equalTo(_nameLabel.mas_bottom);
        }];
    }
    
    
}


@end
