//
//  GMTelephoneBtnView.m
//  Gengmei
//
//  Created by 卢悦明 on 2020/2/20.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMTelephoneBtnView.h"
#import "GMLibraryHeader.h"

@implementation GMTelephoneBtnView

- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setupUI];
    }
    return self;
}

- (void)setupUI {
    _topBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [self addSubview:_topBtn];
    
    _titleLabel = [[UILabel alloc] init];
    _titleLabel.textColor = RGBCOLOR_HEX(0xffffff);
    _titleLabel.font = [UIFont systemFontOfSize:13];
    _titleLabel.textAlignment = NSTextAlignmentCenter;
    [self addSubview:_titleLabel];
}

- (void)layoutSubviews {
    [_topBtn mas_makeConstraints:^(MASConstraintMaker *make) {
       make.size.mas_equalTo(CGSizeMake(self.frame.size.width, self.frame.size.width));
       make.centerX.equalTo(self.mas_centerX);
       make.top.equalTo(self.mas_top);
    }];
    [_titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.mas_left);
        make.right.equalTo(self.mas_right);
        make.bottom.equalTo(self.mas_bottom);
    }];
}

- (void)imageName:(NSString *)name tileText:(NSString *)text {
        [_topBtn setImage:[UIImage imageNamed:name] forState:UIControlStateNormal];
        [_topBtn setImage:[UIImage imageNamed:name] forState:UIControlStateHighlighted];
        [_topBtn setImage:[UIImage imageNamed:name] forState:UIControlStateSelected];
    _titleLabel.text = text;
}

- (void)clickBtn {
    
}
@end
