//
//  GMTelephoneView.m
//  Gengmei
//
//  Created by 卢悦明 on 2020/2/20.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMTelephoneView.h"
#import "GMTelephoneBtnView.h"
#import "GMVideoTelephoneRequestTool.h"
#import "UITabBar+BottomSafe.h"
#import "GMUserFillMessageView.h"
#import "GMVideoPhobos.h"
#import "GMLibraryHeader.h"

@implementation GMTelephoneView
{
    GMTelephoneBtnView *jieting;
    GMTelephoneBtnView *quxiao;
    GMUserFillMessageView *_userMessageLabel;
    UILabel *_centerL;
    UILabel *_sourceL;
}

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        //超时后 服务端要去医生挂断
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(timeClose) name:@"gm_telephone_cancal" object:nil];
        //用户点击取消，服务端要去医生挂断
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(closeTelephone) name:@"gm_user_cancal" object:nil];
        [self setupUI];
    }
    return self;
}

- (void)setupUI {
    self.backgroundColor = RGBCOLOR_HEX(0x303133);
    _userMessageLabel = [[GMUserFillMessageView alloc] initWithFrame:CGRectMake(0, OCNavigationBar.barHeight - 10, [UIScreen mainScreen].bounds.size.width, 80)];
    [self addSubview:_userMessageLabel];
    
    _centerL = [[UILabel alloc] init];
    _centerL.textColor = UIColor.whiteColor;
    _centerL.textAlignment = NSTextAlignmentCenter;
    _centerL.text = @"对方申请视频面诊";
    _centerL.font = [UIFont boldSystemFontOfSize:21];
    [self addSubview:_centerL];
    
    _sourceL = [[UILabel alloc] init];
    _sourceL.textColor = RGBCOLOR_HEX(0xcccccc);
    _sourceL.textAlignment = NSTextAlignmentCenter;
    _sourceL.font = [UIFont systemFontOfSize:14];
    [self addSubview:_sourceL];
    
    quxiao = [[GMTelephoneBtnView alloc] init];
    [quxiao imageName:@"telephone_guaduan" tileText:@"取消"];
    [quxiao.topBtn addTarget:self action:@selector(selectedCancel) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:quxiao];
    
    jieting = [[GMTelephoneBtnView alloc] init];
    [jieting imageName:@"telephone_jieting" tileText:@"接听"];
    [jieting.topBtn addTarget:self action:@selector(selectedContent) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:jieting];
    
    
    
}

- (void)layoutSubviews {

    
    [_centerL mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.mas_left);
        make.right.equalTo(self.mas_right);
        make.centerY.equalTo(self.mas_centerY);
    }];
    
    [_sourceL mas_makeConstraints:^(MASConstraintMaker *make) {
           make.left.equalTo(self.mas_left);
           make.right.equalTo(self.mas_right);
           make.top.equalTo(_centerL.mas_bottom).offset(8);
    }];
    
    
    CGFloat bottom =  UIView.safeAreaInsetsBottom + 20;

    [jieting mas_makeConstraints:^(MASConstraintMaker *make) {
        make.height.mas_equalTo(75);
        make.width.mas_equalTo(55);
        make.bottom.equalTo(self.mas_bottom).offset(-bottom);
        make.right.equalTo(self.mas_right).offset(-60);
    }];
    [quxiao mas_makeConstraints:^(MASConstraintMaker *make) {
       make.height.mas_equalTo(75);
       make.width.mas_equalTo(55);
       make.bottom.equalTo(jieting.mas_bottom);
       make.left.equalTo(self.mas_left).offset(60);
    }];
}


- (void)setModel:(GMVideoTelephoneModel *)model {
    _model = model;
    _userMessageLabel.model = _model;
    _sourceL.text = [NSString stringWithFormat:@"来源：%@",_model.refererText];
}

- (void)selectedContent {
    [self shagnbao:GMEventType_jieTing];
    [self relaseView:YES];
}

- (void)selectedCancel {
    [self shagnbao:GMEventType_juJue];
    [self relaseView:NO];
}

- (void)shagnbao:(GMEventType)type {
    [GMVideoTelephoneRequestTool telephoneMessageEventType:type consultationRecordId:_model.consultationRecordId finishBlock:nil];
}

#pragma mark - 服务端要去关闭试图
- (void)timeClose {
    [self relaseView:NO];
    [GMHudModule showWarning:@"超时未接听,对方已取消"];
}

#pragma mark - 对方取消挂断
- (void)closeTelephone {
    [self relaseView:NO];
    [GMHudModule showWarning:@"对方已取消"];
}

- (void)relaseView:(BOOL)status {
    if ([self.delegate respondsToSelector:@selector(clickBtnType: messageModel:)]) {
        [self.delegate clickBtnType:status messageModel:_model];
    }
}

- (void)dealloc {
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}
@end
