//
//  GMUserFillMessageView.m
//  Gengmei
//
//  Created by 卢悦明 on 2020/3/9.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMUserFillMessageView.h"
#import "UITabBar+BottomSafe.h"
#import "GMLibraryHeader.h"
@implementation GMUserFillMessageView
{
    UIImageView *_iconImgV;
    UILabel *_nameLabeL;
    UILabel *_messageL;
    UILabel *_yiMeiL;
}
- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setupUI];
    }
    return self;
}
- (void)setupUI {
    self.backgroundColor = UIColor.clearColor;
    _iconImgV = [[UIImageView alloc] init];
    _iconImgV.layer.masksToBounds = YES;
    _iconImgV.layer.cornerRadius = 30;
    _iconImgV.contentMode = UIViewContentModeScaleAspectFill;
    [self addSubview:_iconImgV];
   
    _nameLabeL = [[UILabel alloc] init];
    _nameLabeL.textColor = UIColor.whiteColor;
    _nameLabeL.font = [UIFont boldSystemFontOfSize:16];
    [self addSubview:_nameLabeL];
   
    
    
    _messageL = [[UILabel alloc] init];
    _messageL.textColor = UIColor.whiteColor;
    _messageL.font = [UIFont systemFontOfSize:12];
    [self addSubview:_messageL];
   
    
    _yiMeiL = [[UILabel alloc] init];
    _yiMeiL.textColor = UIColor.whiteColor;
    _yiMeiL.font = [UIFont systemFontOfSize:12];
    [self addSubview:_yiMeiL];
}

- (void)layoutSubviews {
    [_iconImgV mas_makeConstraints:^(MASConstraintMaker *make) {
          make.size.mas_equalTo(CGSizeMake(60, 60));
          make.centerY.equalTo(self.mas_centerY);
          make.left.mas_equalTo(20);
    }];
      
    [_nameLabeL mas_makeConstraints:^(MASConstraintMaker *make) {
          make.left.equalTo(_iconImgV.mas_right).offset(8);
          make.top.equalTo(_iconImgV.mas_top);
    }];
    [_messageL mas_makeConstraints:^(MASConstraintMaker *make) {
          make.left.equalTo(_nameLabeL.mas_left);
          make.top.equalTo(_nameLabeL.mas_bottom).offset(8);;
    }];

    [_yiMeiL mas_makeConstraints:^(MASConstraintMaker *make) {
       make.left.equalTo(_nameLabeL.mas_left);
       make.top.equalTo(_messageL.mas_bottom).offset(8);;
       make.right.equalTo(self.mas_right).offset(-22);
    }];
}

- (void)setModel:(GMVideoTelephoneModel *)model {
    _model = model;
    [_iconImgV sd_setImageWithURL:[NSURL URLWithString:_model.userInfo.portrait]];
    _nameLabeL.text = _model.userInfo.name;
    _messageL.text = [GMVideoTelephoneModel detialStr:_model];
    _yiMeiL.text = [GMVideoTelephoneModel zixunName:_model];
}
@end
