//
//  GMTelephoneFunctionView.h
//  Gengmei
//
//  Created by 卢悦明 on 2020/2/19.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import <UIKit/UIKit.h>

typedef NS_ENUM(NSUInteger, TelephoneFunctionType) {
    TelephoneFunctionType_shopping = 100,
    TelephoneFunctionType_song = 101,
    TelephoneFunctionType_guaDuan = 102,
    TelephoneFunctionType_minWindow = 103,
    TelephoneFunctionType_switchCamera = 104,
};


@protocol GMTelephoneFunctionViewDelegate <NSObject>

- (void)clicBtnAction:(TelephoneFunctionType)type Status:(BOOL)status;
/// 记录通话时长
/// @param currentTime 时长
- (void)userTimeChange:(int)currentTime;
@end

@interface GMUserTelephoneFunctionView : UIView
@property (nonatomic, weak) id<GMTelephoneFunctionViewDelegate>delegate;

- (void)changMutedSelf:(BOOL)status;
/// 时长
@property (nonatomic, assign) CGFloat currentTime;


/// 开始计时
- (void)startTime;

/// 结束计时
- (void)endTime;
@end

