//
//  GMTelephoneFunctionView.m
//  Gengmei
//
//  Created by 卢悦明 on 2020/2/19.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMUserTelephoneFunctionView.h"
#import "GMTelephoneProxy.h"
@import GMKit;
@implementation GMUserTelephoneFunctionView
{
    UIButton *shoppingBtn; //购物
    UIButton *mineBtn; // 最小窗口
    UIButton *songBtn; //静音
    UIButton *guaduanBtn;//挂断安
    UIButton *switchCamera;//切换摄像头
    UILabel *timeLabel;
    NSTimer *_timer;//计时器
}

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setupUI];
    }
    return self;
}

- (void)setupUI {
    
    timeLabel = [[UILabel alloc] init];
    timeLabel.textColor = [UIColor whiteColor];
    timeLabel.font = [UIFont systemFontOfSize:13];
    timeLabel.textAlignment = NSTextAlignmentCenter;
    [self addSubview:timeLabel];
    [timeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.mas_left);
        make.right.equalTo(self.mas_right);
        make.top.equalTo(self.mas_top);
        make.height.mas_equalTo(15);
    }];
    
    CGFloat space = (MAINSCREEN_WIDTH - 160 - 64)/6;
    guaduanBtn = [self creatBtnImageName:@"telephone_guaduan" action:@selector(clickBtn:)];
    guaduanBtn.tag = 102;
    [self addSubview:guaduanBtn];
    [guaduanBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(64, 64));
        make.centerX.equalTo(self.mas_centerX);
        make.top.equalTo(timeLabel.mas_bottom).offset(20);
    }];
    UILabel *label2 = [self creatLabelText:@"挂断"];
    [self addSubview:label2];
    [label2 mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(guaduanBtn.mas_bottom).offset(16);
        make.centerX.equalTo(guaduanBtn.mas_centerX);
        make.size.mas_equalTo(CGSizeMake(64, 15));
    }];
    
    shoppingBtn = [self creatBtnImageName:@"telephone_shopping" action:@selector(clickBtn:)];
    shoppingBtn.tag = 100;
    [self addSubview:shoppingBtn];
    [shoppingBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(40, 40));
        make.left.equalTo(self.mas_left).offset(space);
        make.centerY.equalTo(guaduanBtn.mas_centerY);
    }];
    
    UILabel *label0 = [self creatLabelText:@"推荐商品"];
    [self addSubview:label0];
    [label0 mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(label2.mas_centerY);
        make.centerX.equalTo(shoppingBtn.mas_centerX);
        make.size.mas_equalTo(CGSizeMake(60, 15));
    }];
    
    songBtn = [self creatBtnImageName:@"telephone_song" action:@selector(clickBtn:)];
    songBtn.tag = 101;
    [songBtn setImage:[UIImage imageNamed:@"telephone_closeSong"] forState:UIControlStateSelected];
    [self addSubview:songBtn];
    [songBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(40, 40));
        make.left.equalTo(shoppingBtn.mas_right).offset(space);
        make.centerY.equalTo(guaduanBtn.mas_centerY);
    }];
    UILabel *label1 = [self creatLabelText:@"静音"];
    [self addSubview:label1];
    [label1 mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(label2.mas_centerY);
        make.centerX.equalTo(songBtn.mas_centerX);
        make.size.mas_equalTo(CGSizeMake(40, 15));
    }];
    
    
    
    mineBtn = [self creatBtnImageName:@"telephone_mini" action:@selector(clickBtn:)];
    mineBtn.tag = 103;
    [self addSubview:mineBtn];
    [mineBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(40, 40));
        make.left.equalTo(guaduanBtn.mas_right).offset(space);
        make.centerY.equalTo(guaduanBtn.mas_centerY);
    }];
    
    UILabel *label3 = [self creatLabelText:@"最小化"];
    [self addSubview:label3];
    [label3 mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(label2.mas_centerY);
        make.centerX.equalTo(mineBtn.mas_centerX);
        make.size.mas_equalTo(CGSizeMake(40, 15));
    }];
    
    switchCamera = [self creatBtnImageName:@"telephone_camera" action:@selector(clickBtn:)];
    switchCamera.tag = 104;
    [self addSubview:switchCamera];
    [switchCamera mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(40, 40));
        make.left.equalTo(mineBtn.mas_right).offset(space);
        make.centerY.equalTo(guaduanBtn.mas_centerY);
    }];
    
    UILabel *label4 = [self creatLabelText:@"翻转相机"];
    [self addSubview:label4];
    [label4 mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(label2.mas_centerY);
        make.centerX.equalTo(switchCamera.mas_centerX);
        make.size.mas_equalTo(CGSizeMake(60, 15));
    }];
    
    
    
}

- (UILabel *)creatLabelText:(NSString *)text {
    UILabel *label = [[UILabel alloc] init];
    label.text = text;
    label.textColor = RGBCOLOR_HEX(0xffffff);
    label.font = [UIFont systemFontOfSize:13];
    label.textAlignment = NSTextAlignmentCenter;
    return label;
}

- (UIButton *)creatBtnImageName:(NSString *)name action:(SEL)action {
    UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
    [btn addTarget:self action:action forControlEvents:UIControlEventTouchUpInside];
    [btn setBackgroundImage:[UIImage imageNamed:name] forState:UIControlStateNormal];
    [btn setBackgroundImage:[UIImage imageNamed:name] forState:UIControlStateHighlighted];
    [btn setBackgroundImage:[UIImage imageNamed:name] forState:UIControlStateSelected];
    return btn;
}

- (void)clickBtn:(UIButton *)sender {
    sender.selected = !sender.selected;
    if ([self.delegate respondsToSelector:@selector(clicBtnAction:Status:)]) {
        [self.delegate clicBtnAction:sender.tag Status:sender.selected];
    }
}


/// 开始计时
- (void)startTime {
    _timer = [NSTimer timerWithTimeInterval:1.0 target:[GMTelephoneProxy proxyWithTarget:self] selector:@selector(timeRepeat) userInfo:nil repeats:YES];

    [[NSRunLoop currentRunLoop] addTimer:_timer forMode:NSRunLoopCommonModes];
    [self timeRepeat];
}

/// 结束计时
- (void)endTime {
    [self setTimeText];
    [_timer setFireDate:[NSDate distantFuture]];
}

- (void)timeRepeat
{
    [self setTimeText];
    _currentTime ++;
}

- (void)setTimeText {
    if (_currentTime < 3600) {//小于1小时
        _currentTime = round(_currentTime);
        int min =_currentTime / 60;
        int sec = (int)(_currentTime) % 60;
        timeLabel.text = [NSString stringWithFormat:@"%d:%02d", min, sec];
    }else{
        _currentTime = round(_currentTime);
        int hose = _currentTime / 3600;
        int subTime = _currentTime - hose * 3600;
        int min = subTime / 60;
        int sec = (int)(subTime) % 60;
        timeLabel.text = [NSString stringWithFormat:@"%d:%02d:%02d", hose, min, sec];
    }
    if ([self.delegate respondsToSelector:@selector(userTimeChange:)]) {
        [self.delegate userTimeChange:(int)_currentTime];
    }
}
- (void)changMutedSelf:(BOOL)status {
    songBtn.selected = status;
}
- (void)dealloc {
    [_timer invalidate];
    _timer = nil;
}
@end
