//
//  GMVideoTelephoneRecommendShoppingView.m
//  Gengmei
//
//  Created by 卢悦明 on 2020/2/20.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMVideoTelephoneRecommendShoppingView.h"
#import "GMVideoTelephoneRecommodWelfareTableViewCell.h"
#import "GMTelephoneShoppingEmptyView.h"
#import "GMVideoTelephoneRequestTool.h"
#import "GMLibraryHeader.h"

@interface GMVideoTelephoneRecommendShoppingView ()<UITableViewDelegate, UITableViewDataSource>
{
    UIView *_topView;
    UITableView *_tableView;
    GMTelephoneShoppingEmptyView *_emptyView;
    NSMutableArray *_dataSource;
}

@end

@implementation GMVideoTelephoneRecommendShoppingView

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        _dataSource = [NSMutableArray array];
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(reloadTableMessage) name:@"gm_push_reloadWelfare" object:nil];
        [self setupUI];
    }
    return self;
}

- (void)setupUI {
    _serviceIdArray = [NSMutableArray array];
    
    
    _tableView = [[UITableView alloc] initWithFrame:CGRectMake(0,MAINSCREEN_HEIGHT -  400 , MAINSCREEN_WIDTH, 400) style:UITableViewStylePlain];
    _tableView.delegate = self;
    _tableView.dataSource = self;
    _tableView.showsHorizontalScrollIndicator = NO;
    [_tableView setSeparatorStyle:UITableViewCellSeparatorStyleNone];
    [_tableView registerClass:[GMVideoTelephoneRecommodWelfareTableViewCell class] forCellReuseIdentifier:@"cell"];
    [self addSubview:_tableView];
    __weak typeof(self) weakSelf = self;
    
    _tableView.mj_header = [GMRefreshHeader headerWithRefreshingBlock:^{
        [weakSelf reloadTableMessage];
    }];
    _emptyView = [[GMTelephoneShoppingEmptyView alloc] initWithFrame:CGRectMake(0, MAINSCREEN_HEIGHT - 333, MAINSCREEN_WIDTH, 333)];
    [_emptyView.closeBtn addTarget:self action:@selector(tapClose) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:_emptyView];
    
    _topView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, MAINSCREEN_WIDTH, MAINSCREEN_HEIGHT - 400)];
    _topView.backgroundColor = [UIColor clearColor];
    [self addSubview:_topView];
    UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(tapClose)];
    [_topView addGestureRecognizer:tap];
    
}

#pragma mark - 重置数据
- (void)reloadTableMessage {
    NSDictionary *params = @{
        @"record_id":_recordId,
    };
    [GMVideoTelephoneRequestTool userVideoTelephoneRecommodWelfare:params finished:^(BOOL success, NSMutableArray *dataArray) {
        [_tableView.mj_header endRefreshing];
        if (success) {
            [_dataSource removeAllObjects];
            [_serviceIdArray removeAllObjects];
           _dataSource = dataArray;
            
           if (_dataSource.count == 0) {
               [self showType:NO];
           } else {
               [self showType:YES ];
               [_tableView reloadData];
               for (GMTelephoneRecommodWelfareModel *model in _dataSource) {
                   [_serviceIdArray addObject:model.serviceId];
               }
           }
        }
       
    }];
}

- (void)showType:(BOOL) status  {
    if (status) {
        _emptyView.hidden = YES;
        _tableView.hidden = NO;
        _topView.frame = CGRectMake(0, 0, MAINSCREEN_WIDTH, MAINSCREEN_HEIGHT - 400);
    } else {
        _emptyView.hidden = NO;
        _tableView.hidden = YES;
        _topView.frame = CGRectMake(0, 0, MAINSCREEN_WIDTH, MAINSCREEN_HEIGHT - 333);
    }
}

- (void)tapClose {
    if ([self.delegate respondsToSelector:@selector(closeShoppingView)]) {
        [self.delegate closeShoppingView];
    }
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return _dataSource.count;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    return 114;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    GMVideoTelephoneRecommodWelfareTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"cell"];
    GMTelephoneRecommodWelfareModel *model = _dataSource[indexPath.row];
    cell.model = model;
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    GMTelephoneRecommodWelfareModel *model = _dataSource[indexPath.row];
    if ([self.delegate respondsToSelector:@selector(selectedIndex:welfareId:)]) {
        [self.delegate selectedIndex:indexPath.row welfareId:model.serviceId];
    }
}

- (void)dealloc {
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}
@end
