//
//  GMVideoTelephoneRecommodWelfareTableViewCell.m
//  Gengmei
//
//  Created by 卢悦明 on 2020/2/20.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMVideoTelephoneRecommodWelfareTableViewCell.h"
@import GMBase;
@import SDWebImage;
@implementation GMVideoTelephoneRecommodWelfareTableViewCell
{
    UIImageView *_iconImg;
    UILabel *_titleLabel;
    UILabel *_priceLabel;
}

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier {
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self setSelectionStyle:UITableViewCellSelectionStyleNone];
        [self setupUI];
    }
    return self;
}

- (void)setupUI {
    UIView *back = [[UIView alloc] init];
    [self addSubview:back];
    [back mas_makeConstraints:^(MASConstraintMaker *make) {
        make.height.mas_equalTo(114);
        make.edges.mas_equalTo(UIEdgeInsetsZero);
    }];
    
    _iconImg = [[UIImageView alloc] init];
    _iconImg.backgroundColor = UIColor.redColor;
    _iconImg.layer.masksToBounds = YES;
    _iconImg.layer.cornerRadius = 5.0;
    [back addSubview:_iconImg];
    [_iconImg mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(16);
        make.size.mas_equalTo(CGSizeMake(80, 80));
        make.centerY.mas_equalTo(0);
    }];
    
    _titleLabel = [[UILabel alloc] init];
    _titleLabel.font = [UIFont boldSystemFontOfSize:15];
    _titleLabel.numberOfLines = 2;
    
    _titleLabel.textColor = RGBCOLOR_HEX(0x464646);
    [back addSubview:_titleLabel];
    [_titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(_iconImg.mas_right).offset(10);
        make.top.equalTo(_iconImg.mas_top);
        make.right.equalTo(back.mas_right).offset(-16);
    }];
    
    _priceLabel= [[UILabel alloc] init];
    _priceLabel.font = [UIFont boldSystemFontOfSize:20];
    _priceLabel.textColor = RGBCOLOR_HEX(0xFF2F4F);
    [back addSubview:_priceLabel];
    [_priceLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(_titleLabel.mas_left);
        make.bottom.equalTo(_iconImg.mas_bottom);
    }];

    
    UIImageView *imageView = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"telephone_shopingAa"]];
    [self addSubview:imageView];
    [imageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.equalTo(self.mas_right).offset(-19);
        make.bottom.equalTo(_iconImg.mas_bottom);
        make.size.mas_equalTo(CGSizeMake(14, 13));
    }];
    
    UILabel *bottomLine = [[UILabel alloc] init];
    bottomLine.backgroundColor = RGBCOLOR_HEX(0xe2e2e2);
    [back addSubview:bottomLine];
    [bottomLine mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(back.mas_left).offset(16);
        make.right.equalTo(back.mas_right).offset(-16);
        make.height.mas_equalTo(0.35);
        make.bottom.equalTo(back.mas_bottom);
    }];
}

- (void)setModel:(GMTelephoneRecommodWelfareModel *)model {
    _model = model;
    [_iconImg sd_setImageWithURL:[NSURL URLWithString:_model.image]];
    _titleLabel.text = _model.shortDescription;
    NSString *price = [NSString stringWithFormat:@"¥ %@", _model.gengmeiPrice];
    NSMutableAttributedString *attr = [[NSMutableAttributedString alloc] initWithString:price];
    [attr addAttribute:NSFontAttributeName value:[UIFont systemFontOfSize:14] range:NSMakeRange(0, 1)];
    _priceLabel.attributedText = attr;
    
}
@end
