//
//  GMWaitingSuccessView.m
//  Gengmei
//
//  Created by yefengming on 2020/3/6.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMWaitingSuccessView.h"
#import "GMUserVideoTelephoneLogin.h"
#import "GMLibraryHeader.h"
//#import <GMBase/GMBase-Swift.h>
#import <GMBaseSwift/GMBaseSwift-Swift.h>
//@import GMBaseSwift
@import GMBaseSwift;
@interface GMWaitingSuccessView ()
{
    NSTimer *_timer;
    CGFloat currentTime;
}
@property (nonatomic, strong) GMImageView *doctorView;
@property (nonatomic, strong) GMLabel *nameLabel;
@property (nonatomic, strong) GMLabel *infoLabel;
// 好评率，有效面诊，接通率
@property (nonatomic, strong) GMLabel *rateLabel;
@property (nonatomic, strong) GMLabel *hospitalLabel;
@property (nonatomic, strong) GMLabel *projectLabel;
@property (nonatomic, strong) GMImageView *iconView;
@property (nonatomic, strong) GMLabel *successLabel;
@property (nonatomic, strong) GMLabel *successInfoLabel;
@property (nonatomic, strong) WYTagView *tagView;
@end

@implementation GMWaitingSuccessView

- (void)setup {
    [super setup];
    // 监听 successview 啥时候移除
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(dismissSelf) name:@"gm_push_remove_waiting_success" object:nil];

    self.container.size = CGSizeMake(MAINSCREEN_WIDTH, 323 + UIView.safeAreaInsetsBottom);
    [self containerRectCorner:self.container];
    
    self.doctorView = [[GMImageView alloc] init];
    self.doctorView.layer.cornerRadius = 40;
    self.doctorView.layer.masksToBounds = YES;
    [self.container addSubview:self.doctorView];
    
    self.nameLabel = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0x282828) fontSize:16];
    self.nameLabel.font = [UIFont gmBoldFont:16];
    [self.container addSubview:self.nameLabel];
    
    self.infoLabel = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0x8E8E8E) fontSize:12];
    [self.container addSubview:self.infoLabel];
    
    self.hospitalLabel = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0x282828) fontSize:16];
    self.hospitalLabel.font = [UIFont gmBoldFont:16];
    [self.container addSubview:self.hospitalLabel];
    
    self.rateLabel = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0x8E8E8E)  fontSize:12];
    [self.container addSubview:self.rateLabel];
    
    self.projectLabel = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0x282828) fontSize:13];
    self.projectLabel.text = @"擅长项目：";
    [self.container addSubview:self.projectLabel];
    
    self.iconView = [[GMImageView alloc] init];
    self.iconView.layer.cornerRadius = 28;
    self.iconView.layer.masksToBounds = YES;
    [self.container addSubview:self.iconView];
    
    NSMutableAttributedString *attribute = [[NSMutableAttributedString alloc] initWithString:@"- 匹配成功 -"];
    [attribute addAttribute:NSForegroundColorAttributeName value:RGBCOLOR_HEX(0x4ABAB4) range:NSMakeRange(0, 1)];
    [attribute addAttribute:NSForegroundColorAttributeName value:RGBCOLOR_HEX(0x4ABAB4) range:NSMakeRange(7, 1)];
    self.successLabel = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0x282828) fontSize:16];
    self.successLabel.textAlignment = NSTextAlignmentCenter;
    self.successLabel.font = [UIFont gmBoldFont:16];
    self.successLabel.attributedText = attribute;
    [self.container addSubview:self.successLabel];
    
    NSMutableAttributedString *attribute2 = [[NSMutableAttributedString alloc] initWithString:@"5S 后开启摄像头进行视频通话\n建议您选择安静、光线充足的环境"];
    [attribute2 addAttribute:NSForegroundColorAttributeName value:RGBCOLOR_HEX(0x4ABAB4) range:NSMakeRange(0, 2)];
    self.successInfoLabel = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0x282828) fontSize:14];
    self.successInfoLabel.textAlignment = NSTextAlignmentCenter;
    self.successInfoLabel.numberOfLines = 0;
    self.successInfoLabel.attributedText = attribute2;
    [self.container addSubview:self.successInfoLabel];
    
    self.tagView = [[WYTagView alloc] initWithMaxWidth:(MAINSCREEN_WIDTH - 90) maxTagCount:3 tagSpace:8 customLabelUI:^(GMLabel *label) {
        label.backgroundColor = RGBCOLOR_HEX(0xEEF8F7);
        label.textAlignment = NSTextAlignmentCenter;
        label.font = [UIFont gmFont:11];
        label.textColor = RGBCOLOR_HEX(0x4DBBB5);
        label.paddingEdge = UIEdgeInsetsMake(1, 11, 1, 11);
        label.layer.cornerRadius = ONE_PIXEL + 1;
        label.layer.masksToBounds = YES;
        label.height = 17;
    }];
    [self.container addSubview:self.tagView];
    
    [self.doctorView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(25);
        make.left.mas_equalTo(18);
        make.size.mas_equalTo(CGSizeMake(80, 80));
    }];
    
    [self.nameLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.doctorView.mas_top);
        make.height.mas_equalTo(16);
        make.left.mas_equalTo(self.doctorView.mas_right).offset(10);
    }];
    
    [self.infoLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.nameLabel.mas_bottom).offset(8);
        make.height.mas_equalTo(12);
        make.left.mas_equalTo(self.nameLabel.mas_left);
    }];
    
    [self.hospitalLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.infoLabel.mas_bottom).offset(5);
        make.height.mas_equalTo(16);
        make.left.mas_equalTo(self.nameLabel);
    }];
    
    [self.rateLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.hospitalLabel.mas_bottom).offset(5);
        make.height.mas_equalTo(16);
        make.left.mas_equalTo(self.nameLabel);
    }];
    
    [self.projectLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.doctorView.mas_bottom).offset(10);
        make.left.mas_equalTo(self.doctorView);
    }];
    
    [self.tagView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(self.projectLabel.mas_right);
        make.centerY.mas_equalTo(self.projectLabel);
        make.right.mas_equalTo(-5);
    }];
    
    [self.successInfoLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.mas_equalTo(-18-UIView.safeAreaInsetsBottom);
        make.centerX.mas_equalTo(0);
    }];
    
    [self.successLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.mas_equalTo(self.successInfoLabel.mas_top).offset(-9);
        make.centerX.mas_equalTo(0);
    }];
    
    [self.iconView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.mas_equalTo(self.successLabel.mas_top).offset(-7);
        make.centerX.mas_equalTo(0);
        make.size.mas_equalTo(CGSizeMake(56, 56));
    }];
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(didBecomeActive)
                                                 name:UIApplicationDidBecomeActiveNotification object:nil];
}
- (void)containerRectCorner:(UIView *)view {
    UIBezierPath *maskPath = [UIBezierPath bezierPathWithRoundedRect:view.bounds byRoundingCorners:UIRectCornerTopLeft | UIRectCornerTopRight cornerRadii:CGSizeMake(12, 12)];
    CAShapeLayer *maskLayer = [[CAShapeLayer alloc] init];
    maskLayer.frame = view.bounds;
    maskLayer.path = maskPath.CGPath;
    view.layer.mask = maskLayer;
}
- (void)didBecomeActive {
    [self invalidateCountDownTimer];
    [[GMUserVideoTelephoneLogin sharedVideoTelephoneLogin] userEnterVideoRoom:self.info extension:nil];
}

- (void)setObject:(GMNoticeInfoObject *)object {
    _object = object;
    currentTime = object.countdown / 1000.0;
    [self addCountDownTimer];
    [self.doctorView setImageWithUrlString:object.portraitUrl placeHolder:nil];
    [self.iconView setImageWithUrlString:object.iconUrl placeHolder:nil];
    self.nameLabel.text = object.name;
    self.infoLabel.text = object.titleText;
    self.hospitalLabel.text = object.hospitalName;
    self.rateLabel.hidden = _object.showType == 0;
    self.rateLabel.attributedText = [self rateLabelText];
    [self.tagView setTags:object.goodAt];
}

- (NSMutableAttributedString *)rateLabelText {
    NSMutableAttributedString *content = [[NSMutableAttributedString alloc] init];
    // 0：不显示1: 好评率 + 接通率 2: 好评率 + 有效面诊人数
    if (_object.showType == 1) {
        NSAttributedString *subContentA = [[NSAttributedString alloc] initWithString:@"好评率：" attributes:@{NSFontAttributeName: [UIFont gmFont:12], NSForegroundColorAttributeName: RGBCOLOR_HEX(0x282828)}];
        NSAttributedString *subContent = [[NSAttributedString alloc] initWithString:SafeString(_object.likeRate) attributes:@{NSFontAttributeName: [UIFont gmFont:12], NSForegroundColorAttributeName: RGBCOLOR_HEX(0x7DC6CC)}];
        
        NSAttributedString *subContentB = [[NSAttributedString alloc] initWithString:@"    接通率：" attributes:@{NSFontAttributeName: [UIFont gmFont:12], NSForegroundColorAttributeName: RGBCOLOR_HEX(0x282828)}];
        NSAttributedString *subContentC = [[NSAttributedString alloc] initWithString:SafeString(_object.connectRate) attributes:@{NSFontAttributeName: [UIFont gmFont:12], NSForegroundColorAttributeName: RGBCOLOR_HEX(0x7DC6CC)}];
        [content appendAttributedString: subContentA];
        [content appendAttributedString: subContent];
        [content appendAttributedString: subContentB];
        [content appendAttributedString: subContentC];
        return content;
    } else {
        NSAttributedString *subContentA = [[NSAttributedString alloc] initWithString:@"好评率：" attributes:@{NSFontAttributeName: [UIFont gmFont:12], NSForegroundColorAttributeName: RGBCOLOR_HEX(0x282828)}];
               NSAttributedString *subContent = [[NSAttributedString alloc] initWithString:SafeString(_object.likeRate) attributes:@{NSFontAttributeName: [UIFont gmFont:12], NSForegroundColorAttributeName: RGBCOLOR_HEX(0x7DC6CC)}];
               
               NSAttributedString *subContentB = [[NSAttributedString alloc] initWithString:@"    有效面诊：" attributes:@{NSFontAttributeName: [UIFont gmFont:12], NSForegroundColorAttributeName: RGBCOLOR_HEX(0x282828)}];
               NSAttributedString *subContentC = [[NSAttributedString alloc] initWithString:SafeString(_object.consultPeopleNumber) attributes:@{NSFontAttributeName: [UIFont gmFont:12], NSForegroundColorAttributeName: RGBCOLOR_HEX(0x7DC6CC)}];
               [content appendAttributedString: subContentA];
               [content appendAttributedString: subContent];
               [content appendAttributedString: subContentB];
               [content appendAttributedString: subContentC];
               return content;
    }
}

- (void)addCountDownTimer {
    // 展示倒计时
    if (_object.showCountdown) {
        _timer = [NSTimer scheduledTimerWithTimeInterval:1 target:self selector:@selector(updateCountDown) userInfo:nil repeats:YES];
        [_timer fire];
    } else { // 不展示倒计时
        self.successInfoLabel.text = SafeString(_object.countdownText);
        // 等待一段时间移除页面，接通视频
        dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(currentTime * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
            [[GMUserVideoTelephoneLogin sharedVideoTelephoneLogin] userEnterVideoRoom:self.info extension:nil];
        });
    }
}


- (void)hide {
    
}

- (void)dismissSelf {
    [self removeFromSuperview];
}

- (void)updateCountDown {
    if (currentTime >= 0) {
        NSMutableAttributedString *attribute = [[NSMutableAttributedString alloc] initWithString:[NSString stringWithFormat:@"%dS %@\n建议您选择安静、光线充足的环境", currentTime, _object.countdownText]];
        [attribute addAttribute:NSForegroundColorAttributeName value:RGBCOLOR_HEX(0x4ABAB4) range:NSMakeRange(0, 2)];
        self.successInfoLabel.attributedText = attribute;
        currentTime --;
    } else {
        [self invalidateCountDownTimer];
        [[GMUserVideoTelephoneLogin sharedVideoTelephoneLogin] userEnterVideoRoom:self.info extension:nil];
    }
}

- (void)invalidateCountDownTimer{
    [_timer invalidate];
    _timer = nil;
}

- (void)dealloc {
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}

@end
