//
//  GMEditQuesPartModel.h
//  Gengmei
//
//  Created by Locus on 2020/2/19.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//
@import GMBase;

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger, GMEditQuesPartType) {
    GMEditQuesPartTypeSectionTag,
    GMEditQuesPartTypeImproveAppeal,
    GMEditQuesPartTypeSuitProject
};

@protocol GMEditQuesPartDetailModel @end
@interface GMEditQuesPartDetailModel : GMObject

@property (nonatomic, assign) NSInteger id;
@property (nonatomic, copy) NSString *name;

@end

@interface GMEditQuesPartModel : GMObject

@property (nonatomic, copy) NSString *reportitemId;
@property (nonatomic, strong, nullable) GMEditQuesPartDetailModel *sectionTag;
@property (nonatomic, strong, nullable) NSArray<GMEditQuesPartDetailModel> *sectionTags;
@property (nonatomic, strong, nullable) NSArray<GMEditQuesPartDetailModel> *improveAppeals;
@property (nonatomic, strong, nullable) NSArray<GMEditQuesPartDetailModel> *suitProjects;
@property (nonatomic, copy, nullable) NSString *otherSuggestions;

@property (nonatomic, copy) NSString<Ignore> *improveAppealNamesStr;
@property (nonatomic, copy) NSString<Ignore> *suitProjectNamesStr;

@property (nonatomic, copy) NSString<Ignore> *improveAppealIdsStr;
@property (nonatomic, copy) NSString<Ignore> *suitProjectIdsStr;

@end

NS_ASSUME_NONNULL_END
