//
//  GMCommonTipAlertView.m
//  Gengmei
//
//  Created by Jessica on 2020/2/22.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMCommonTipAlertView.h"
#import "UIView+CornerRadius.h"
#import <GMBase/GMBaseTool.h>

@import GMBase;
@import GMFoundation;
@interface GMCommonTipAlertView()
@property(nonatomic, strong) GMLabel *title;
@property(nonatomic, strong) GMLabel *contentLabel;
@property(nonatomic, strong) UIButton *leftBtn;
@property(nonatomic, strong) UIButton *rightBtn;
@property(nonatomic, strong) UIView *line;
@property(nonatomic, strong) UIView *contentView;

@end

static GMCommonTipAlertView *_alertView = nil;
@implementation GMCommonTipAlertView
- (void)setup {
    [super setup];
    
    self.animationType = GMPopupAnimationTypeFade;
    
    self.container.hidden = YES;
    
    self.contentView = [UIView new];
    self.contentView.backgroundColor = UIColor.whiteColor;
    [self addSubview:_contentView];
    [self.contentView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.width.mas_equalTo(285);
        make.centerX.mas_equalTo(self);
        make.centerY.mas_equalTo(self);
    }];
    
    _title = [[GMLabel alloc] init];
    _title.textColor = RGBCOLOR_HEX(0x282828);
    _title.textAlignment = NSTextAlignmentCenter;
    _title.font = [UIFont gmBoldFont:18];
    [_title setContentHuggingPriority:UILayoutPriorityRequired forAxis:UILayoutConstraintAxisHorizontal];
    [_title setContentCompressionResistancePriority:UILayoutPriorityRequired forAxis:UILayoutConstraintAxisHorizontal];
    [_contentView addSubview:_title];
    
    _contentLabel = [[GMLabel alloc] init];
    _contentLabel.textColor = RGBCOLOR_HEX(0x282828);
    _contentLabel.textAlignment = NSTextAlignmentCenter;
    _contentLabel.font = [UIFont gmFont:17];
    _contentLabel.numberOfLines = 0;
    _contentLabel.lineBreakMode = NSLineBreakByWordWrapping;
    [_contentLabel setContentHuggingPriority:UILayoutPriorityRequired forAxis:UILayoutConstraintAxisHorizontal];
    [_contentLabel setContentCompressionResistancePriority:UILayoutPriorityRequired forAxis:UILayoutConstraintAxisHorizontal];
    [_contentView addSubview:_contentLabel];
    
    UIView *separatedView = [[UIView alloc] init];
    separatedView.backgroundColor = UIColor.background;
    [_contentView addSubview:separatedView];
    [separatedView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.mas_equalTo(0);
        make.bottom.mas_equalTo(-44);
        make.height.mas_equalTo(1);
    }];
    
    _leftBtn = [UIButton new];
    _leftBtn.titleLabel.font = [UIFont gmFont:16];
    [_leftBtn setTitleColor:RGBCOLOR_HEX(0x999999) forState:UIControlStateNormal];
    [_contentView addSubview:_leftBtn];
    [_leftBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.height.mas_equalTo(44);
        make.width.mas_equalTo(142);
        make.left.mas_equalTo(0);
        make.bottom.mas_equalTo(_contentView.mas_bottom);
    }];
    
    _line = [[UIView alloc] init];
    _line.backgroundColor = UIColor.background;
    [_contentView addSubview:_line];
    [_line mas_makeConstraints:^(MASConstraintMaker *make) {
        make.width.mas_equalTo(ONE_PIXEL);
        make.height.mas_equalTo(44);
        make.bottom.mas_equalTo(1);
        make.centerX.mas_equalTo(_contentView.mas_centerX);
    }];
    
    _rightBtn = [UIButton new];
    _rightBtn.titleLabel.font = [UIFont gmFont:16];
    [_rightBtn setTitleColor:RGBCOLOR_HEX(0x4ABAB4) forState:UIControlStateNormal];
    [_contentView addSubview:_rightBtn];
    [_rightBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.height.mas_equalTo(44);
        make.width.mas_equalTo(142);
        make.right.mas_equalTo(0);
        make.bottom.mas_equalTo(_contentView.mas_bottom);
    }];

}

- (void)updateConstraints {
    [super updateConstraints];
    [_title mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(23);
        make.right.mas_equalTo(-23);
        make.top.mas_equalTo(28);
    }];
    
    [_contentLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(23);
        make.right.mas_equalTo(-23);
        if ([_title.text isNonEmpty]) {
            make.top.mas_equalTo(_title.mas_bottom).offset(12);
        } else {
            make.top.mas_equalTo(28);
        }
        make.bottom.mas_equalTo(_rightBtn.mas_top).offset(-29);
    }];
    
    if ([_leftBtn.titleLabel.text isNonEmpty] && [_rightBtn.titleLabel.text isNonEmpty]) {
        _line.hidden = NO;
    } else if (![_leftBtn.titleLabel.text isNonEmpty] && [_rightBtn.titleLabel.text isNonEmpty]) {
        _line.hidden = YES;
        [_rightBtn mas_updateConstraints:^(MASConstraintMaker *make) {
            make.width.mas_equalTo(self.contentView);
        }];
        [_leftBtn mas_updateConstraints:^(MASConstraintMaker *make) {
            make.width.mas_equalTo(0);
        }];
    } else if ([_leftBtn.titleLabel.text isNonEmpty] && ![_rightBtn.titleLabel.text isNonEmpty]) {
        _line.hidden = YES;
        [_rightBtn mas_updateConstraints:^(MASConstraintMaker *make) {
            make.width.mas_equalTo(0);
        }];
        [_leftBtn mas_updateConstraints:^(MASConstraintMaker *make) {
            make.width.mas_equalTo(self.contentView);
        }];
    }
    
    self.contentView.layer.masksToBounds = YES;
    self.contentView.layer.cornerRadius = 10;
}

+(void)showAtertWithTitle:(NSString *)title content:(NSString *)content leftBtnText:(NSString *)leftBtnText rightBtnText:(NSString *)rightBtnText leftAction:(SEL)leftAction rightAction:(SEL)rightAction target:(nullable id)target {
    _alertView = [[GMCommonTipAlertView alloc] initWithFrame:CGRectMake(0, 0, MAINSCREEN_WIDTH, MAINSCREEN_HEIGHT)];
    _alertView.title.text = title;
    _alertView.contentLabel.text = content;
    [_alertView.leftBtn setTitle:leftBtnText forState:UIControlStateNormal];
    [_alertView.rightBtn setTitle:rightBtnText forState:UIControlStateNormal];
    [_alertView.rightBtn  addTarget:target action:rightAction forControlEvents:UIControlEventTouchUpInside];
    [_alertView.leftBtn  addTarget:target action:leftAction forControlEvents:UIControlEventTouchUpInside];
    [_alertView updateConstraints];
    [[GMBaseTool getCurrentViewController].view addSubview:_alertView];
}

+(void)hideAtertView {
    [_alertView hide];
}

@end
