//
//  GMComplaintResultView.m
//  Gengmei
//
//  Created by zhouLiang on 2020/2/21.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMComplaintResultView.h"
#import "NSAttributedString+YYText.h"
#import "YYLabel.h"
@import GMRouter;
//#import "GMCustomerServiceDetailViewController.h"

@interface GMComplaintResultCellView : UIView
@property (nonatomic, strong) GMLabel *titleLabel;
@property (nonatomic, strong) GMLabel *rightLabel;
@property (nonatomic, strong) GMLabel *contentLabel;
- (void)setContent:(NSString *)content timeStr:(NSString *)timeStr;
@end

@implementation GMComplaintResultCellView

- (instancetype)init {
    if (self = [super init]) {
        [self setUI];
        [self setLayout];
    }
    return self;
}

- (void)setUI {
    [self addSubview:self.titleLabel];
    [self addSubview:self.rightLabel];
    [self addSubview:self.contentLabel];
}
- (void)setLayout {
    [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(0);
        make.left.mas_equalTo(22);
        make.size.mas_equalTo(CGSizeMake(60, 20));
    }];
    [self.rightLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(130, 15));
        make.bottom.mas_equalTo(self.titleLabel.mas_bottom);
        make.right.mas_equalTo(-30);
    }];
    [self.contentLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(22);
        make.right.mas_equalTo(-30);
        make.top.equalTo(self.titleLabel.mas_bottom).offset(5);
        make.bottom.mas_equalTo(0);
    }];
}
- (void)setContent:(NSString *)content timeStr:(NSString *)timeStr {
    self.contentLabel.text = content;
    self.rightLabel.text = timeStr;
    [self.contentLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(22);
        make.right.mas_equalTo(-30);
        make.top.equalTo(self.titleLabel.mas_bottom).offset(5);
        make.bottom.mas_equalTo(0);
    }];
}
- (GMLabel *)titleLabel {
    if (!_titleLabel) {
        _titleLabel = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0x666666) fontSize:14];
        _titleLabel.font = [UIFont gmBoldFont:14];
        _titleLabel.textAlignment = NSTextAlignmentLeft;
    }
    return _titleLabel;
}
- (GMLabel *)rightLabel {
    if (!_rightLabel) {
        _rightLabel = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0x999999) fontSize:11];
        _rightLabel.textAlignment = NSTextAlignmentRight;
    }
    return _rightLabel;
}
- (GMLabel *)contentLabel {
    if (!_contentLabel) {
        _contentLabel = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0x666666) fontSize:13];
        _contentLabel.numberOfLines = 0;
    }
    return _contentLabel;
}
@end

@interface GMComplaintResultView ()
@property (nonatomic, strong) UIView *grayLineView;
@property (nonatomic, strong) GMLabel *titleLabel;
@property (nonatomic, strong) GMButton *cancelButton;
@property (nonatomic, strong) NSArray *textArray;
@property (nonatomic, assign) GMComplaintResultViewType type;
@property (nonatomic, strong) NSDictionary *dict;
/** 问题描述 */
@property (nonatomic, strong) GMComplaintResultCellView *questionCell;
/** 处理结果 */
@property (nonatomic, strong) GMComplaintResultCellView *resultCell;
@property (nonatomic, strong) YYLabel *callPhoneLabel;
@property (nonatomic, strong) UIView *lineView;
@property (nonatomic, strong) GMComplaintObject *dictModel;
@end

@implementation GMComplaintResultView

- (instancetype)initWithType:(GMComplaintResultViewType)type dictModel:(GMComplaintObject *)dictModel {
    if (self = [super init]) {
        self.type = type;
        self.dictModel = dictModel;
        dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(0.1 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
            [self containerRectCorner:self.container];
        });
    }
    return self;
}
- (void)containerRectCorner:(UIView *)view {
    UIBezierPath *maskPath = [UIBezierPath bezierPathWithRoundedRect:view.bounds byRoundingCorners:UIRectCornerTopLeft | UIRectCornerTopRight cornerRadii:CGSizeMake(12, 12)];
    CAShapeLayer *maskLayer = [[CAShapeLayer alloc] init];
    maskLayer.frame = view.bounds;
    maskLayer.path = maskPath.CGPath;
    view.layer.mask = maskLayer;
}
- (void)setup {
    [super setup];
    [self setUI];
    [self setLayout];
}
- (void)setUI {
    [self.container addSubview:self.grayLineView];
    [self.container addSubview:self.titleLabel];
    [self.container addSubview:self.cancelButton];
    [self.container addSubview:self.questionCell];
    [self.container addSubview:self.lineView];
    [self.container addSubview:self.resultCell];
    [self.container addSubview:self.callPhoneLabel];
}
- (void)setLayout {
    [self.grayLineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_offset(0);
        make.top.mas_equalTo(10);
        make.size.mas_equalTo(CGSizeMake(50, 5));
    }];
    [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_offset(0);
        make.top.mas_offset(30);
        make.size.mas_offset(CGSizeMake(MAINSCREEN_WIDTH, 16));
    }];
    [self.cancelButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_offset(CGSizeMake(17, 17));
        make.top.mas_offset(20);
        make.right.mas_offset(-20);
    }];
    [self.questionCell mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.mas_equalTo(0);
        make.top.mas_equalTo(74);
    }];
    [self.lineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(23);
        make.right.mas_equalTo(-23);
        make.top.equalTo(self.questionCell.mas_bottom).offset(15);
        make.height.mas_equalTo(0.5);
    }];
    [self.resultCell mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.mas_equalTo(0);
        make.top.equalTo(self.lineView.mas_bottom).offset(15);
    }];
    [self.callPhoneLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.mas_equalTo(-22);
        make.top.equalTo(self.resultCell.mas_bottom).offset(10);
        make.bottom.mas_offset(-(14+UIView.safeAreaInsetsBottom));
        make.height.mas_equalTo(15);
    }];
    [self.container mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.right.bottom.mas_equalTo(0);
    }];
}
- (void)setDictModel:(GMComplaintObject *)dictModel {
    _dictModel = dictModel;
    // 问题
    [self.questionCell setContent:dictModel.report_detail timeStr:dictModel.report_time];
    // 处理结果
    [self.resultCell setContent:dictModel.deal_detail timeStr:dictModel.deal_time];
    
    if (self.type == GMComplaintResultViewTypeInAudit) {
        self.resultCell.rightLabel.text = @"审核处理中";
        self.resultCell.rightLabel.textColor = RGBCOLOR_HEX(0xFF2F4F);
    }
    self.titleLabel.text = self.textArray[self.type];
}
- (UIView *)grayLineView {
    if (!_grayLineView) {
        _grayLineView = [[UIView alloc] init];
        _grayLineView.backgroundColor = RGBCOLOR_HEX(0xEEEEEE);
        _grayLineView.layer.cornerRadius = 2.5f;
        _grayLineView.layer.masksToBounds = YES;
    }
    return _grayLineView;
}
- (GMLabel *)titleLabel {
    if (!_titleLabel) {
        _titleLabel = [GMLabel labelWithTextColor:UIColor.headlineText fontSize:16];
        _titleLabel.font = [UIFont gmBoldFont:16];
        _titleLabel.textAlignment = NSTextAlignmentCenter;
    }
    return _titleLabel;
}
- (NSArray *)textArray {
    if (!_textArray) {
        _textArray = @[@"投诉审核中",@"投诉成功",@"投诉失败",@""];
    }
    return _textArray;
}
- (GMComplaintResultCellView *)questionCell {
    if (!_questionCell) {
        _questionCell = [[GMComplaintResultCellView alloc] init];
        _questionCell.titleLabel.text = @"问题描述";
    }
    return _questionCell;
}
- (GMComplaintResultCellView *)resultCell {
    if (!_resultCell) {
        _resultCell = [[GMComplaintResultCellView alloc] init];
        _resultCell.titleLabel.text = @"处理结果";
    }
    return _resultCell;
}
- (GMButton *)cancelButton {
    if (!_cancelButton) {
        _cancelButton = [GMButton buttonWithType:UIButtonTypeCustom];
        _cancelButton.enableAdaptive = YES;
        [_cancelButton setBackgroundImage:[UIImage imageNamed:@"wt_cancel_icon"] forState:UIControlStateNormal];
        [_cancelButton addTarget:self action:@selector(hide) forControlEvents:UIControlEventTouchUpInside];
    }
    return _cancelButton;
}
- (YYLabel *)callPhoneLabel {
    if (!_callPhoneLabel) {
        NSMutableAttributedString *text = [[NSMutableAttributedString alloc] initWithString:@"如你对处理结果有异议，可联系客服"];
        text.yy_font = [UIFont gmFont:11];
        text.yy_color = RGBCOLOR_HEX(0x999999);
        [text yy_setUnderlineStyle:NSUnderlineStyleSingle range:NSMakeRange(12, 4)];
        [text yy_setUnderlineColor:[UIColor colorWithHex:0x4DBBB5] range:NSMakeRange(12, 4)];
        [text yy_setTextHighlightRange:NSMakeRange(12, 4) color:[UIColor colorWithHex:0x4DBBB5] backgroundColor:[UIColor clearColor] tapAction:^(UIView * _Nonnull containerView, NSAttributedString * _Nonnull text, NSRange range, CGRect rect) {
            [self hide];
            [[GMRouter sharedInstance] pushScheme:self.dictModel.custom_url];
        }];
        _callPhoneLabel = [[YYLabel alloc] init];
        _callPhoneLabel.textAlignment = NSTextAlignmentRight;
        _callPhoneLabel.attributedText = text;
    }
    return _callPhoneLabel;
}
- (UIView *)lineView {
    if (!_lineView) {
        _lineView = [[UIView alloc] init];
        _lineView.backgroundColor = RGBCOLOR_HEX(0xF8F8F8);
    }
    return _lineView;
}
@end
