//
//  GMDiagnosisWorkingTableSwitch.h
//  Gengmei
//
//  Created by Jessica on 2020/2/19.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//
@import GMBase;

typedef NS_ENUM(NSInteger, DiagnosisWorkingTableSwitchStatus) {
    DiagnosisWorkingTableSwitchStatusOff      = 1,// 关闭 (可以开启)
    DiagnosisWorkingTableSwitchStatusOn       = 2,// 开启 (可以关闭)
    DiagnosisWorkingTableSwitchStatusIng       = 3 // 面诊中
};

@protocol GMDiagnosisWorkingTableSwitchDelegate <NSObject>
// 点击
-(void)diagnosisWorkingTableSwitchDidSelectedWithStatus:(DiagnosisWorkingTableSwitchStatus)status successBlock:(void (^)(BOOL isSuccess))successBlock;

@end

@interface GMDiagnosisWorkingTableSwitch : GMImageView
@property (nonatomic, assign) id<GMDiagnosisWorkingTableSwitchDelegate> delegate;
// YES ： 开启面诊状态 NO ： 关闭面诊状态
@property (nonatomic, assign) BOOL isSelected;

@end
