//
//  GMDoctorConsultatioPromptView.m
//  Gengmei
//
//  Created by 卢悦明 on 2020/3/10.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMDoctorConsultatioPromptView.h"
@import GMBase;
@implementation GMDoctorConsultatioPromptView

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setupUI];
    }
    return self;
}

- (void)setupUI {
    self.backgroundColor = [[UIColor blackColor] colorWithAlphaComponent:0.5f];
    
    UIView *backView = [[UIView alloc] init];
    backView.backgroundColor = [UIColor whiteColor];
    backView.layer.cornerRadius = 10;
    [self addSubview:backView];
    
    [backView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.mas_centerX);
        make.centerY.equalTo(self.mas_centerY);
        make.size.mas_equalTo(CGSizeMake(285, 294));
    }];
    
    UILabel *title = [[UILabel alloc] init];
    title.text = @"面诊派单说明";
    title.font = [UIFont boldSystemFontOfSize:18];
    title.textColor = RGBCOLOR_HEX(0x282828);
    title.textAlignment = NSTextAlignmentCenter;
    [backView addSubview:title];
    [title mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(backView.mas_left).offset(24);
        make.right.mas_equalTo(backView.mas_right).offset(-24);
        make.top.equalTo(backView.mas_top).offset(30);
        make.height.mas_equalTo(20);
    }];
    
    UILabel *title1 = [[UILabel alloc] init];
    title1.text = @"1.面诊派单只分配给保持「开启面诊」状态的医生和面诊师，请务必保持「开启面诊」状态；";
    CGFloat height1 = [self getHeight:title1.text font:14 LimitWidth:237];
    title1.font = [UIFont systemFontOfSize:14];
    title1.numberOfLines = 0;
    title1.textColor = RGBCOLOR_HEX(0x282828);
    title1.textAlignment = NSTextAlignmentLeft;
    [backView addSubview:title1];
    [title1 mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(title.mas_left);
        make.right.mas_equalTo(title.mas_right);
        make.top.equalTo(title.mas_bottom).offset(15);
        make.height.mas_equalTo(height1);
    }];
    
    UILabel *title2 = [[UILabel alloc] init];
    title2.text = @"2.每个面诊派单都有一定时长的有效期，超过有效期未抢即视为放弃本次面诊派单的抢单机会；";
    CGFloat height2 = [self getHeight:title2.text font:14 LimitWidth:237];
    title2.font = [UIFont systemFontOfSize:14];
    title2.numberOfLines = 0;
    title2.textColor = RGBCOLOR_HEX(0x282828);
    title2.textAlignment = NSTextAlignmentLeft;
    [backView addSubview:title2];
    [title2 mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(title.mas_left);
        make.right.mas_equalTo(title.mas_right);
        make.top.equalTo(title1.mas_bottom).offset(8);
        make.height.mas_equalTo(height2);
    }];
    
    UILabel *title3 = [[UILabel alloc] init];
    title3.text = @"3.抢单成功后会直接进入视频面诊环节，请提前进行相关面诊环境和面诊话术的准备。";
    title3.font = [UIFont systemFontOfSize:14];
    title3.textColor = RGBCOLOR_HEX(0x282828);
    title3.numberOfLines = 0;
    title3.textAlignment = NSTextAlignmentLeft;
    CGFloat height3 = [self getHeight:title3.text font:14 LimitWidth:237];
    [backView addSubview:title3];
    [title3 mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(title.mas_left);
        make.right.mas_equalTo(title.mas_right);
        make.top.equalTo(title2.mas_bottom).offset(8);
        make.height.mas_equalTo(height3);
    }];
    
    UILabel *line = [[UILabel alloc] init];
    line.backgroundColor = RGBCOLOR_HEX(0xe2e2e2);
    [backView addSubview:line];
    [line mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(0);
        make.right.mas_equalTo(0);
        make.top.equalTo(title3.mas_bottom).offset(16);
        make.height.mas_equalTo(0.35);
    }];
    
    UIButton *knowBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [knowBtn setTitle:@"知道了" forState:UIControlStateNormal];
    knowBtn.titleLabel.font = [UIFont systemFontOfSize:16];
    knowBtn.layer.masksToBounds = YES;
    knowBtn.layer.cornerRadius = 10;
    [knowBtn setTitleColor:RGBCOLOR_HEX(0x4ABAB4) forState:UIControlStateNormal];
    [knowBtn addTarget:self action:@selector(clickKnow) forControlEvents:UIControlEventTouchUpInside];
    [backView addSubview:knowBtn];
    [knowBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(0);
        make.right.mas_equalTo(0);
        make.top.equalTo(line.mas_top);
        make.bottom.mas_equalTo(0);
    }];
    
    UIButton *deleteBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [deleteBtn setImage:[UIImage imageNamed:@"telephone_welfareClose"] forState:UIControlStateNormal];
    [deleteBtn addTarget:self action:@selector(clickDelet) forControlEvents:UIControlEventTouchUpInside];
    [backView addSubview:deleteBtn];
    [deleteBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(30, 30));
        make.top.equalTo(backView.mas_top).offset(5);
        make.right.equalTo(backView.mas_right).offset(-5);
    }];
    
}

- (void)clickKnow {
    [self removeFromSuperview];
}

- (void)clickDelet {
    [self removeFromSuperview];
}

- (CGFloat)getHeight:(NSString *)message font:(CGFloat)font LimitWidth:(CGFloat)width
{
    if (message) {
        if (message.length==0) {
            return 0;
        }
        CGFloat height = ceil([message boundingRectWithSize:CGSizeMake(width, MAXFLOAT) options: NSStringDrawingUsesLineFragmentOrigin | NSStringDrawingUsesFontLeading attributes:@{NSFontAttributeName: [UIFont systemFontOfSize:font]} context:nil].size.height);
        return height;
    }else{
        return 0;
    }
    
}
@end
