//
//  GMEditQuesPartSelectView.m
//  Gengmei
//
//  Created by Locus on 2020/2/19.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMEditQuesPartSelectView.h"
#import "GMEditQuesPartController.h"
#import <GMBase/GMBaseTool.h>


@interface GMEditQuesPartSelectCell : GMTableViewCell

@property (nonatomic, strong) GMEditQuesPartDetailModel *model;
@property (nonatomic, strong) NSArray<GMEditQuesPartDetailModel> *selectArray;
@property (nonatomic, strong) GMButton *selectButton;

@end

@implementation GMEditQuesPartSelectCell

- (void)setup {
    [super setup];
    self.textLabel.font = [UIFont gmFont:16];
    self.textLabel.textColor = [UIColor colorWithHex:0x333333];
    
    self.selectButton = [GMButton buttonWithType:UIButtonTypeCustom];
    [self.selectButton setBackgroundImage:[UIImage imageNamed:@"to_face_edit_ques_part_normal"] forState:UIControlStateNormal];
    [self.selectButton setBackgroundImage:[UIImage imageNamed:@"to_face_edit_ques_part_select"] forState:UIControlStateSelected];
    self.selectButton.userInteractionEnabled = NO;
    [self.contentView addSubview:self.selectButton];
}

- (void)updateConstraints {
    [super updateConstraints];
    [self.textLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_offset(0);
        make.left.mas_offset(15);
        make.right.mas_offset(-40);
    }];
    [self.selectButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_offset(CGSizeMake(20, 20));
        make.centerY.mas_offset(0);
        make.right.mas_offset(-15);
    }];
    [self updateBottomLineConstraintsWithLeft:15 right:-15];
}

- (void)setModel:(GMEditQuesPartDetailModel *)model {
    _model = model;
    self.textLabel.text = model.name;
}

@end

@interface GMEditQuesPartSelectTableView : GMTableView <UITableViewDelegate, UITableViewDataSource>

@property (nonatomic, assign) GMEditQuesPartType type;
@property (nonatomic, strong) NSArray<GMEditQuesPartDetailModel> *dataArray;
@property (nonatomic, strong) NSMutableArray<GMEditQuesPartDetailModel> *selectArray;
@property (nonatomic, strong) GMEditQuesPartSelectCell *selectedCell;

@end

@implementation GMEditQuesPartSelectTableView

- (void)setup {
    [super setup];
    self.delegate = self;
    self.dataSource = self;
    self.estimatedRowHeight = 50;
    [self registerCell:[GMEditQuesPartSelectCell class]];
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.dataArray.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    GMEditQuesPartDetailModel *model = self.dataArray[indexPath.row];
    GMEditQuesPartSelectCell *cell = (GMEditQuesPartSelectCell *)[tableView dequeueCell:[GMEditQuesPartSelectCell class] forIndexPath:indexPath];
    cell.selectArray = self.selectArray;
    cell.model = model;
    __block BOOL isSelect = NO;
    [self.selectArray enumerateObjectsUsingBlock:^(GMEditQuesPartDetailModel *obj, NSUInteger idx, BOOL * _Nonnull stop) {
        if (obj.id == model.id) {
            isSelect = YES;
        }
    }];
    cell.selectButton.selected = isSelect;
    if (self.type == GMEditQuesPartTypeSectionTag && isSelect) {
        self.selectedCell = cell;
    }
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    GMEditQuesPartSelectCell *cell = [tableView cellForRowAtIndexPath:indexPath];
    if (self.type == GMEditQuesPartTypeSectionTag) {
        if (self.selectedCell.model.id == cell.model.id) {
            cell.selectButton.selected = NO;
            self.selectedCell = nil;
            [_selectArray removeAllObjects];
        } else {
            self.selectedCell.selectButton.selected = NO;
            cell.selectButton.selected = YES;
            self.selectedCell = cell;
            _selectArray = [@[cell.model] mutableCopy];
        }
    } else {
        if (cell.selectButton.selected) {
            [_selectArray enumerateObjectsUsingBlock:^(GMEditQuesPartDetailModel *obj, NSUInteger idx, BOOL * _Nonnull stop) {
                if (obj.id == cell.model.id) {
                    [_selectArray removeObjectAtIndex:idx];
                    *stop = YES;
                }
            }];
            cell.selectButton.selected = NO;
        } else {
            if (self.selectArray.count < 3) {
                [_selectArray addObject:cell.model];
                cell.selectButton.selected = YES;
            } else {
                [[GMBaseTool getCurrentViewController] toast:@"最多选3个"];
            }
        }
    }
}

@end

@interface GMEditQuesPartSelectView ()

@property (nonatomic, assign) GMEditQuesPartType type;
@property (nonatomic, strong) GMButton *cancelButton;
@property (nonatomic, strong) GMButton *confirmButton;
@property (nonatomic, strong) GMLabel *titleLabel;
@property (nonatomic, strong) GMEditQuesPartSelectTableView *tableView;

@end

@implementation GMEditQuesPartSelectView

- (void)setup {
    [super setup];
    self.animationType = GMPopupAnimationTypeFlipFromBottom;
    self.container.backgroundColor = [UIColor whiteColor];

    self.container.layer.cornerRadius = 10;
    self.container.clipsToBounds = YES;
    [self.container mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.right.mas_equalTo(0);
        make.height.mas_equalTo(343 + UIView.safeAreaInsetsBottom);
        make.bottom.mas_offset(10);
    }];
    
    [self.container addSubview:self.titleLabel];
    [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_offset(0);
        make.top.mas_offset(30);
    }];
    
    [self.container addSubview:self.cancelButton];
    [self.cancelButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_offset(CGSizeMake(30, 16));
        make.top.mas_offset(20);
        make.left.mas_offset(13);
    }];
    
    [self.container addSubview:self.confirmButton];
    [self.confirmButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_offset(CGSizeMake(30, 16));
        make.top.mas_offset(20);
        make.right.mas_offset(-13);
    }];
    
    [self.container addSubview:self.tableView];
    [self.tableView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.mas_offset(0);
        make.top.mas_offset(65);
        make.bottom.mas_offset(-10 - UIView.safeAreaInsetsBottom);
    }];
}

- (void)selectType:(GMEditQuesPartType)type title:(NSString *)title {
    _type = type;
    _titleLabel.text = [NSString stringWithFormat:@"选择%@", title];
    self.tableView.type = type;
    GMEditQuesPartController *quesPartVC = (GMEditQuesPartController *)self.pageCtrl;
    if (type == GMEditQuesPartTypeSectionTag) {
        self.tableView.dataArray = quesPartVC.viewModel.selectListModel.sectionTags;
        self.tableView.selectArray = (quesPartVC.viewModel.editModel.sectionTag ? [@[quesPartVC.viewModel.editModel.sectionTag] mutableCopy] : [NSMutableArray new]);
    } else if (type == GMEditQuesPartTypeImproveAppeal) {
        self.tableView.dataArray = quesPartVC.viewModel.selectListModel.improveAppeals;
        self.tableView.selectArray = (NSMutableArray<GMEditQuesPartDetailModel> *)[NSMutableArray arrayWithArray:quesPartVC.viewModel.editModel.improveAppeals];
    } else {
        self.tableView.dataArray = quesPartVC.viewModel.selectListModel.suitProjects;
        self.tableView.selectArray = (NSMutableArray<GMEditQuesPartDetailModel> *)[NSMutableArray arrayWithArray:quesPartVC.viewModel.editModel.suitProjects];
    }
    if (self.tableView.dataArray.count == 0) {
        [quesPartVC.viewModel requestSelectListDataWithType:self.type finishBlock:^(NSArray<GMEditQuesPartDetailModel> * _Nonnull list) {
            self.tableView.dataArray = list;
            [self.tableView reloadData];
        }];
    } else {
        [self.tableView reloadData];
    }
}

- (void)confirmButtonClick {
    [self hide];
    GMEditQuesPartController *quesPartVC = (GMEditQuesPartController *)self.pageCtrl;
    if (self.type == GMEditQuesPartTypeSectionTag) {
        quesPartVC.viewModel.editModel.sectionTag = self.tableView.selectArray.firstObject;
        quesPartVC.viewModel.editModel.improveAppeals = nil;
        quesPartVC.viewModel.editModel.suitProjects = nil;
        quesPartVC.viewModel.selectListModel.improveAppeals = nil;
        quesPartVC.viewModel.selectListModel.suitProjects = nil;
        [quesPartVC.viewModel requestSelectListDataWithType:GMEditQuesPartTypeImproveAppeal finishBlock:nil];
    } else if (self.type == GMEditQuesPartTypeImproveAppeal) {
        quesPartVC.viewModel.editModel.improveAppeals = self.tableView.selectArray;
        quesPartVC.viewModel.editModel.suitProjects = nil;
        quesPartVC.viewModel.selectListModel.suitProjects = nil;
        [quesPartVC.viewModel requestSelectListDataWithType:GMEditQuesPartTypeSuitProject finishBlock:nil];
    } else {
        quesPartVC.viewModel.editModel.suitProjects = self.tableView.selectArray;
    }
    self.tableView.dataArray = nil;
    [self.tableView reloadData];
    if ([self.selectDelegate respondsToSelector:@selector(editQuesPartSelectFinish)]) {
        [self.selectDelegate editQuesPartSelectFinish];
    }
}

- (GMLabel *)titleLabel {
    if (!_titleLabel) {
        _titleLabel = [GMLabel labelWithTextColor:UIColor.headlineText fontSize:18];
        _titleLabel.font = [UIFont gmBoldFont:18];
    }
    return _titleLabel;
}

- (GMButton *)confirmButton {
    if (!_confirmButton) {
        _confirmButton = [GMButton buttonWithType:UIButtonTypeCustom];
        [_confirmButton setTitle:@"确定" forState:UIControlStateNormal];
        [_confirmButton setTitleColor:RGBCOLOR_HEX(0xFF8C8D) forState:UIControlStateNormal];
        [_confirmButton addTarget:self action:@selector(confirmButtonClick) forControlEvents:UIControlEventTouchUpInside];
        _confirmButton.titleLabel.font = [UIFont gmFont:14];
    }
    return _confirmButton;
}

- (GMButton *)cancelButton {
    if (!_cancelButton) {
        _cancelButton = [GMButton buttonWithType:UIButtonTypeCustom];
        [_cancelButton setTitle:@"取消" forState:UIControlStateNormal];
        [_cancelButton setTitleColor:[UIColor colorWithHex:0xBFC2CC] forState:UIControlStateNormal];
        [_cancelButton addTarget:self action:@selector(hide) forControlEvents:UIControlEventTouchUpInside];
        _cancelButton.titleLabel.font = [UIFont gmFont:14];
    }
    return _cancelButton;
}

- (GMEditQuesPartSelectTableView *)tableView {
    if (!_tableView) {
        _tableView = [[GMEditQuesPartSelectTableView alloc] init];
    }
    return _tableView;
}

@end
