//
//  GMEndConsultView.h
//  Gengmei
//
//  Created by Locus on 2020/2/20.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMStarWithContentObject.h"
@import GMBase;

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger, GMEndConsultViewType) {
    GMEndConsultViewTypeDefault,            // 不需要填写报告弹窗
    GMEndConsultViewTypeReport,             // 需要填写报告弹窗
    GMEndConsultViewTypeComplaintFinish,    // 投诉成功弹窗
    GMEndConsultViewTypeDoctorComplaint,    // 医生投诉弹窗
    GMEndConsultViewTypeUserComplaint,      // 用户投诉弹窗
    GMEndConsultViewTypeGrayStar,           // 评价未点星弹框    
    GMEndConsultViewTypeViewEvaluate        // 查看评价
};

typedef NS_ENUM(NSInteger, GMComplaintType) {
    GMComplaintTypeUser,//用户
    GMComplaintTypeDoctor//医生
};

@interface GMEndConsultView : GMPopupBgView

@property (nonatomic, copy) NSString *recordId;// 面诊id

@property (nonatomic, assign) GMComplaintType complaintType;
/** 投诉完成的回调 */
@property (nonatomic, copy) void(^complaintFinish)(NSInteger complaintStatus);
/**
 * 面诊记录页用到的星级评价的回调
 * type        : 查看为1、填写为0
 * starNum     : 星星数量
 * evaluateStr : 评价内容
 */
@property (nonatomic, copy) void(^evaluateFinish)(NSInteger type, NSInteger starNum, NSString *evaluateStr);
/** 点击投诉如果的回调 */
@property (nonatomic, copy) void(^clickComplaintButtonBlock)();
@property (nonatomic, copy) NSString *desc;// 描述语
//是否展示去投诉字段
@property (nonatomic, assign) BOOL showComplaint;
//星级评价语
@property (nonatomic, strong) NSArray <GMStarInfoObject *>*starContentArray;
//点击右上角的×
@property (nonatomic, copy) void(^hideFinish)(void);
/**
 * starNum:星星数，只有在查看评价的时候才用到，其他类型传可以不传，传了也不会被用到
 */
- (instancetype)initWithType:(GMEndConsultViewType)type starNum:(NSInteger)starNum;

@end

NS_ASSUME_NONNULL_END
