//
//  GMGMDiagnosisWorkingTableScrollView.m
//  Gengmei
//
//  Created by Jessica on 2020/2/19.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMGMDiagnosisWorkingTableScrollView.h"
#import "GMTelephoneProxy.h"
#import "GMMissUsersTipView.h"
#import "GMTelephoneProxy.h"
#import <GMBase/GMBaseTool.h>

@import MJRefresh;
#define kTop 21

@implementation GMScrollItemView
- (void)setup {
    [super setup];
    _infoLabel = [GMLabel labelWithTextColor:UIColor.auxiliaryTextDark fontSize:10];
    [self addSubview:_infoLabel];
    [_infoLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(0);
        make.left.mas_equalTo(0);
        make.height.mas_equalTo(self.mas_height);
    }];
    
    _icon = [[GMImageView alloc] init];
    _icon.image = [UIImage imageNamed:@"wt_tip_gray"];
    _icon.hidden = YES;
    [self addSubview:_icon];
    [_icon mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(0);
        make.left.mas_lessThanOrEqualTo(_infoLabel.mas_right).offset(8);
        make.size.mas_equalTo(CGSizeMake(16, 16));
        make.right.mas_equalTo(self);
    }];
}
@end

@interface GMGMDiagnosisWorkingTableScrollView()<GMMissUsersTipViewHideDelegate>
@property (nonatomic, assign) NSInteger index;
@property (nonatomic, strong) GMScrollItemView *currentItem;
@property (nonatomic, strong) NSMutableArray *itemArr;
@property (nonatomic, strong) GMMissUsersTipView *tipView;

@end
@implementation GMGMDiagnosisWorkingTableScrollView
- (void)setup {
    [super setup];
    _itemArr = [NSMutableArray array];
    self.index = 0;

    _scrollView = [[UIScrollView alloc] init];
    _scrollView.contentSize = CGSizeMake(self.width, self.height * 2);
    _scrollView.showsHorizontalScrollIndicator = NO;
    _scrollView.showsVerticalScrollIndicator = NO;
    _scrollView.pagingEnabled = YES;
    _scrollView.bounces = NO;
    _scrollView.scrollEnabled = NO;
    [self addSubview:_scrollView];
    [_scrollView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.insets(UIEdgeInsetsZero);
    }];
}

- (void)setDataSource:(NSMutableArray *)dataSource {
    if (self.timer.valid) {
           [self invalidateTimer];
       }
    [self removeAllSubviews];
    [self createSubviews];
    
    _dataSource = dataSource;
    
    int i = 0;
    for (NSMutableAttributedString *title in dataSource) {
        GMScrollItemView *itemView = (GMScrollItemView *)_itemArr[i];
        itemView.infoLabel.attributedText = title;
        i++;
    }
    
    // 数据源大于1的时候轮播
    if (dataSource.count > 1) {
        [self begainScrolling];
    }
}

- (void)createSubviews {
    [_itemArr removeAllObjects];
    
    GMScrollItemView *itemView = [[GMScrollItemView alloc] init];
    itemView.tag = 100;
    [itemView addGestureRecognizer:[[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(itemClicked:)]];
    self.currentItem = itemView;
    [_itemArr addObject:itemView];
    [self addSubview:itemView];
    
    [itemView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(0);
        make.right.mas_equalTo(0);
        make.height.mas_equalTo(self.mas_height);
        make.top.mas_equalTo(0);
    }];
        
    GMScrollItemView *nextItemView = [[GMScrollItemView alloc] init];
    nextItemView.tag = 101;
    nextItemView.hidden = YES;
    [nextItemView addGestureRecognizer:[[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(itemClicked:)]];
    [_itemArr addObject:nextItemView];
    [self addSubview:nextItemView];
    
    [nextItemView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(itemView.mas_left);
        make.right.mas_equalTo(0);
        make.height.mas_equalTo(self.mas_height);
        make.top.mas_equalTo(kTop);
    }];
}

- (void)itemClicked:(UITapGestureRecognizer *)sender {
    if ([self.clickDelegate respondsToSelector:@selector(gotoDataDetalsWithType:)]) {
        if ([_currentItem.infoLabel.text containsString:@"面诊报告"]) { // 跳转至「面诊报告-面诊报告列表」页面
            [self.clickDelegate gotoDataDetalsWithType:0];
        } else {
            [self invalidateTimer]; // 暂停滚动
            // 弹出提示气泡
            [[GMBaseTool getCurrentViewController].view addSubview:self.tipView];
        }
    }
}


- (void)updateScrolling {
    self.index++;
    if (self.index > self.dataSource.count-1) {
        self.index = 0;
    }
    
    NSInteger pre = self.index + 1;
    if (pre == self.dataSource.count) {
        pre = 0;
    }
   NSMutableAttributedString *title = self.dataSource[pre];
    
    // 当前展示
    GMScrollItemView *item = [self viewWithTag:(100 + self.index % 2)];
    item.hidden = NO;
    self.currentItem = item;
    item.icon.hidden = self.index == 0;
    
    // 动画后切换到顶部
    GMScrollItemView *preItem = [self viewWithTag:(100 + (self.index % 2 ? 0 : 1))];
    [UIView animateWithDuration:0.5f animations:^{
        item.mj_y = 0;
        preItem.mj_y = -kTop;
    } completion:^(BOOL finished) {
        preItem.infoLabel.attributedText = title;
        preItem.hidden = YES;
        preItem.mj_y = kTop;
    }];
}

- (void)begainScrolling {
    if (self.timer.valid) {
        [self invalidateTimer];
    }
    
    self.timer = [NSTimer timerWithTimeInterval:5.f target:[GMTelephoneProxy proxyWithTarget:self] selector:@selector(updateScrolling) userInfo:nil repeats:YES];
    [[NSRunLoop mainRunLoop] addTimer:self.timer forMode:NSDefaultRunLoopMode];
}

- (void)invalidateTimer {
    self.index = 0;
    [self.timer invalidate];
    self.timer = nil;
}

- (GMMissUsersTipView *)tipView {
    if (!_tipView) {
        _tipView = [[GMMissUsersTipView alloc] initWithFrame:CGRectMake(0, 0, MAINSCREEN_WIDTH, MAINSCREEN_HEIGHT)];
        _tipView.hideDelegate = self;
        _tipView.itemFrame = [self.superview convertRect:self.frame toView:nil];
    }
    return _tipView;
}

#pragma mark - GMMissUsersTipViewHideDelegate
- (void)missUsersTipViewHide {
    [self begainScrolling];
}

-(void)dealloc{
    [self invalidateTimer];
}

@end
