//
//  GMGrabLoadingView.m
//  Gengmei
//
//  Created by Jessica on 2020/3/9.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMGrabLoadingView.h"
#import "GMTelephoneProxy.h"
#import <Lottie/Lottie.h>

@interface GMGrabLoadingAnimaitionView()
@property (nonatomic, strong) UILabel *textLabel;

@end

@implementation GMGrabLoadingAnimaitionView
- (void)setup {
    [super setup];
    [self addSubview:self.animationView];

    [_animationView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(159, 159));
        make.top.mas_equalTo(0);
        make.centerX.mas_equalTo(0);
    }];
    
    _textLabel = [[UILabel alloc] init];
    _textLabel.text = @"正在抢单…";
    _textLabel.textAlignment = NSTextAlignmentCenter;
    _textLabel.textColor = UIColor.whiteColor;
    _textLabel.font = [UIFont gmBoldFont:18];
    [self addSubview:_textLabel];
    [_textLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(_animationView.mas_centerX);
        make.top.mas_equalTo(_animationView.mas_bottom).offset(14);
        make.height.mas_equalTo(25);
        make.bottom.mas_equalTo(0);
    }];
    
}

- (LOTAnimationView *)animationView {
    if (!_animationView) {
        _animationView = [LOTAnimationView animationNamed:@""];
        _animationView.contentMode = UIViewContentModeScaleAspectFit;
        _animationView.loopAnimation = YES;
    }
    return _animationView;
}
@end

@interface GMGrabLoadingTimerView()
@property (nonatomic, strong) UILabel *resultLabel;
@property (nonatomic, strong) UILabel *nextLabel;
@property (nonatomic, strong) UILabel *commandLabel;

@end
@implementation GMGrabLoadingTimerView
- (void)setup {
    [super setup];
    
    _timerLabel = [[UILabel alloc] init];
    _timerLabel.text = @"3";
    _timerLabel.textAlignment = NSTextAlignmentCenter;
    _timerLabel.backgroundColor = UIColor.whiteColor;
    _timerLabel.textColor = RGBCOLOR_HEX(0x4DBBB5);
    _timerLabel.font = [UIFont gmBoldFont:70];
    _timerLabel.layer.masksToBounds = YES;
    _timerLabel.layer.cornerRadius = 50;
    [self addSubview:_timerLabel];
    [_timerLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(100, 100));
        make.centerX.mas_equalTo(0);
        make.top.mas_equalTo(0);
    }];
    
    _resultLabel = [[UILabel alloc] init];
    _resultLabel.text = @"* 恭喜你，抢单成功 *";
    _resultLabel.textAlignment = NSTextAlignmentCenter;
    _resultLabel.textColor = UIColor.whiteColor;
    _resultLabel.font = [UIFont gmBoldFont:18];
    [self addSubview:_resultLabel];
    [_resultLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(_timerLabel.mas_centerX);
        make.top.mas_equalTo(_timerLabel.mas_bottom).offset(12);
        make.height.mas_equalTo(25);
    }];
    
    
    _nextLabel = [[UILabel alloc] init];
    _nextLabel.text = @"即将开启摄像头进入视频通话";
    _nextLabel.textAlignment = NSTextAlignmentCenter;
    _nextLabel.textColor = UIColor.whiteColor;
    _nextLabel.font = [UIFont gmBoldFont:15];
    [self addSubview:_nextLabel];
    [_nextLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(_resultLabel.mas_centerX);
        make.top.mas_equalTo(_resultLabel.mas_bottom).offset(4);
        make.height.mas_equalTo(21);
    }];
    
    
    _commandLabel = [[UILabel alloc] init];
    _commandLabel.text = @"建议你保持站立或坐正，请选择安静、光线良好的环境";
    _commandLabel.textAlignment = NSTextAlignmentCenter;
    _commandLabel.textColor = UIColor.whiteColor;
    _commandLabel.font = [UIFont gmBoldFont:12];
    [self addSubview:_commandLabel];
    [_commandLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(_nextLabel.mas_centerX);
        make.top.mas_equalTo(_nextLabel.mas_bottom).offset(16);
        make.height.mas_equalTo(17);
        make.bottom.mas_equalTo(self.mas_bottom);
    }];
}
@end

@interface GMGrabLoadingView()
@property (nonatomic, strong) GMGrabLoadingAnimaitionView *loadingView;
@property (nonatomic, strong) GMGrabLoadingTimerView *timeView;
@property (nonatomic, strong) NSTimer *timer;
@property (nonatomic, assign) UIBackgroundTaskIdentifier taskId;

@end
@implementation GMGrabLoadingView
- (void)setup {
    [super setup];
    self.animationType = GMPopupAnimationTypeFade;
    self.userInteractionEnabled = NO;
    _loadingView = [[GMGrabLoadingAnimaitionView alloc] init];
    [self addSubview:_loadingView];
    [_loadingView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.width.mas_equalTo(MAINSCREEN_WIDTH);
        make.center.mas_equalTo(0);
    }];
    
    _timeView = [[GMGrabLoadingTimerView alloc] init];
    _timeView.hidden = YES;
    [self addSubview:_timeView];
    [_timeView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.width.mas_equalTo(MAINSCREEN_WIDTH);
        make.center.mas_equalTo(0);
    }];
}
- (void)setTimeCount:(NSInteger)timeCount {
    _timeCount = timeCount;
    _timeView.timerLabel.text = [NSString stringWithFormat:@"%ld", _timeCount];
}

- (void)showLoading:(BOOL)isShow {
    if (isShow) {
        _loadingView.hidden = NO;
        _timeView.hidden = YES;
        [_loadingView.animationView playFromProgress:0 toProgress:1 withCompletion:^(BOOL animationFinished) {}];
    } else {
        _loadingView.hidden = YES;
        _timeView.hidden = NO;
        [_loadingView.animationView stop];
        // 倒计时开始
        [self begainTimerCountDown];
    }
}

- (void)begainTimerCountDown {
    if (self.timer.valid) {
        [self invalidateTimer];
    }
    if (self.taskId == UIBackgroundTaskInvalid) {
        self.taskId = [[UIApplication sharedApplication] beginBackgroundTaskWithExpirationHandler:^{
            [[UIApplication sharedApplication] endBackgroundTask:self.taskId];
            self.taskId = UIBackgroundTaskInvalid;
        }];
    }
    self.timer = [NSTimer timerWithTimeInterval:1 target:[GMTelephoneProxy proxyWithTarget:self] selector:@selector(countDownAction) userInfo:nil repeats:YES];
    [[NSRunLoop mainRunLoop] addTimer:self.timer forMode:NSDefaultRunLoopMode];
}

- (void)countDownAction {
    _timeCount--;
    _timeView.timerLabel.text = [NSString stringWithFormat:@"%ld", _timeCount];
    if (_timeCount <= 0) {
        [self invalidateTimer];
        [self hide];
        [[UIApplication sharedApplication] endBackgroundTask:self.taskId];
        self.taskId = UIBackgroundTaskInvalid;
        if (self.countDownDone) {
            self.countDownDone();
        }
    }
    
}

- (void)invalidateTimer {
    [self.timer invalidate];
    self.timer = nil;
    self.timeCount = 0;
}

- (void)hide {
    [super hide];
    [_loadingView.animationView stop];
    [self invalidateTimer];
}

-(void)dealloc {
    [self invalidateTimer];
}

@end
