//
//  GMBusinessReportListController.m
//  Gengmei
//
//  Created by Locus on 2020/2/21.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMBusinessReportListController.h"
//#import "Gengmei-Swift.h"
#import "GMEndConsultView.h"
#import "GMComplaintResultView.h"
#import "GMComplaintObject.h"
#import "RequestHeader.h"
#import <GMBaseWeb/GMBaseWeb-Swift.h>
#import <GMFoundation/GMFoundation-umbrella.h>
@import GMNetworking;
@import WebKit.WKWebView;
@interface GMBusinessReportListController () <WKBaseWebViewDelegate>

@end

@implementation GMBusinessReportListController

- (void)initController {
    [super initController];
    self.navigationBar.title = @"面诊报告";
}

- (void)viewDidLoad {
    [super viewDidLoad];
    self.webCompent.delegate = self;
    self.fd_interactivePopDisabled = YES;
    self.navigationBar.isShowShadow = YES;
    self.path = API_TREETMENT_BUSINESS_REPORT_LIST;
    [self reloadURL];
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(editQuesPartFinish) name:@"gm_working_edit_question_part_notification" object:nil];
}

- (void)editQuesPartFinish {
    NSDictionary *params = @{@"type" : @(0),
                             @"state" : @(1)
    };
    NSString *jsStr = [NSString stringWithFormat:@"window.gm&&window.gm.pack&&window.gm.pack.run('notificReportState','%@')", [NSString convertToBriefJsonString:params]];
    [self.webCompent.webView evaluateJavaScript:jsStr completionHandler:nil];
}

- (NSString *)moreQueryParameters {
    return [NSString stringWithFormat:@"&doctor_id=%@&counsellor_id=%@",SafeString(self.doctorId),SafeString(self.counsellorId)];
}

- (void)videoDiagnoseComplaint:(NSDictionary *)complaint {
    GMComplaintResultViewType complaintStatus = [complaint[@"status"] integerValue];
    if (complaintStatus == GMComplaintResultViewTypeNone) {
        GMEndConsultView *view = [[GMEndConsultView alloc] initWithType:GMEndConsultViewTypeDoctorComplaint starNum:0];
        view.recordId = complaint[@"record_id"];
        view.complaintType = GMComplaintTypeDoctor;
        view.complaintFinish = ^(NSInteger complaintStatus) {
            NSDictionary *params = @{@"type" : @(1),
                                     @"state" : @(complaintStatus)
            };
            NSString *jsStr = [NSString stringWithFormat:@"window.gm&&window.gm.pack&&window.gm.pack.run('notificReportState','%@')", [NSString convertToBriefJsonString:params]];
            [self.webCompent.webView evaluateJavaScript:jsStr completionHandler:nil];
        };
        [[GMBaseTool getCurrentViewController].view addSubview:view];
    } else {
        GMComplaintObject *dictModel = [[GMComplaintObject alloc] initWithDictionary:complaint error:nil];
        GMComplaintResultView *view = [[GMComplaintResultView alloc] initWithType:complaintStatus dictModel:dictModel];
        [[GMBaseTool getCurrentViewController].view addSubview:view];
    }
}

@end
