//
//  GMEditQuesPartController.m
//  Gengmei
//
//  Created by Locus on 2020/2/18.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMEditQuesPartController.h"
#import "GMEditQuesPartCell.h"
#import "GMEditQuesSuggestCell.h"
#import "GMEditQuesPartSelectView.h"
#import "GMCommonTipAlertView.h"

#import <GMBase/GMBaseTool.h>

@interface GMEditQuesPartController () <GMEditQuesPartSelectViewDelegate>

@property (nonatomic, strong) GMEditQuesPartCell *sectionTagCell;
@property (nonatomic, strong) GMEditQuesPartCell *improveAppealCell;
@property (nonatomic, strong) GMEditQuesPartCell *suitProjectCell;
@property (nonatomic, strong) GMEditQuesSuggestCell *otherSuggestionsCell;
@property (nonatomic, strong) GMEditQuesPartSelectView *selectView;

@property (nonatomic, strong) GMButton *deleteButton;
@property (nonatomic, strong) GMButton *saveButton;

@end

@implementation GMEditQuesPartController
@synthesize viewModel;

- (void)initController {
    [super initController];
    self.viewModel = [GMEditQuesPartViewModel new];
    self.fd_interactivePopDisabled = YES;
    [self.viewModel requestSelectListDataWithType:GMEditQuesPartTypeSectionTag finishBlock:nil];
    self.immediateLoad = NO;
    _needFooterRefresh = NO;
    _needHeaderRefresh = NO;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor = UIColor.whiteColor;
    self.table.backgroundColor = UIColor.whiteColor;
    self.title = self.viewModel.editModel ? @"编辑问题部位" : @"新增问题部位";
    [self addButtons];
    if (!self.viewModel.editModel) {
        self.viewModel.editModel = [GMEditQuesPartModel new];
    }
}

- (void)backAction:(OCNavigationBarButton *)button {
    [self.otherSuggestionsCell.textView resignFirstResponder];
    if ([SafeString(self.otherSuggestionsCell.textView.text) isEqualToString:SafeString(self.viewModel.editModel.otherSuggestions)]) {
        [super backAction:button];
    } else {
        [GMCommonTipAlertView showAtertWithTitle:@"确认要退出？" content:@"退出后编辑过的内容将不保存" leftBtnText:@"取消" rightBtnText:@"确认" leftAction:@selector(hideCommonTipAlertView) rightAction:@selector(backButtonClick) target:self];
    }
}

- (void)backButtonClick {
    [GMCommonTipAlertView hideAtertView];
    [super backAction:self.navigationBar.rightButton];
}

- (void)setupEmptyView {}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return 4;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    return indexPath.row == 3 ? 140 : 80;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.row == 0) {
        return self.sectionTagCell;
    } else if (indexPath.row == 1) {
        return self.improveAppealCell;
    } else if (indexPath.row == 2) {
        return self.suitProjectCell;
    } else if (indexPath.row == 3) {
        return self.otherSuggestionsCell;
    }
    return nil;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.row < 3) {
        [self.otherSuggestionsCell.textView resignFirstResponder];
        GMEditQuesPartCell *cell = [tableView cellForRowAtIndexPath:indexPath];
        GMEditQuesPartType type = cell.type;
        if (type != GMEditQuesPartTypeSectionTag && !self.viewModel.editModel.sectionTag) {
            [self toast:@"请先选择问题部位"];
        } else if (type == GMEditQuesPartTypeSuitProject && self.viewModel.editModel.improveAppeals.count == 0) {
            [self toast:@"请先选择改善诉求"];
        } else {
            [self.selectView selectType:type title:cell.titleLabel.text];
            [[GMBaseTool getCurrentViewController].view addSubview:self.selectView];
        }
    }
}

- (void)editQuesPartSelectFinish {
    self.sectionTagCell.desc = self.viewModel.editModel.sectionTag.name;
    self.improveAppealCell.desc = self.viewModel.editModel.improveAppealNamesStr;
    self.suitProjectCell.desc = self.viewModel.editModel.suitProjectNamesStr;
}

- (void)addButtons {
    if (self.viewModel.editModel) {
        [self.view addSubview:self.deleteButton];
        [self.deleteButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.height.mas_offset(45);
            make.bottom.mas_offset(-13 - UIView.safeAreaInsetsBottom);
            make.left.mas_offset(42);
            make.right.mas_offset(-42);
        }];
    }
    [self.view addSubview:self.saveButton];
    [self.saveButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.height.mas_offset(45);
        make.bottom.mas_offset(-(self.viewModel.editModel ? 68 : 13) - UIView.safeAreaInsetsBottom);
        make.left.mas_offset(42);
        make.right.mas_offset(-42);
    }];
    [self.table mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.bottom.equalTo(self.saveButton.mas_top).offset(-10);
        make.top.mas_offset(OCNavigationBar.barHeight);
        make.left.right.mas_offset(0);
    }];
}

- (void)save {
    self.viewModel.editModel.otherSuggestions = self.otherSuggestionsCell.textView.text;
    [self.viewModel saveQuesPart];
}

- (void)deleteButtonClick {
    if (self.viewModel.isLastData) {
        UIAlertController *vc = [UIAlertController alertControllerWithTitle:@"不可删除" message:@"请至少保留一个问题部位，不可全部删除" preferredStyle:UIAlertControllerStyleAlert];
        [vc addAction:[UIAlertAction actionWithTitle:@"知道了" style:UIAlertActionStyleCancel handler:nil]];
        [self presentViewController:vc animated:YES completion:nil];
    } else {
        [GMCommonTipAlertView showAtertWithTitle:@"确认要删除" content:@"一经删除将不可恢复" leftBtnText:@"取消" rightBtnText:@"确认" leftAction:@selector(hideCommonTipAlertView) rightAction:@selector(deleteQuesPart) target:self];
    }
}

- (void)hideCommonTipAlertView {
    [GMCommonTipAlertView hideAtertView];
}

- (void)deleteQuesPart {
    [GMCommonTipAlertView hideAtertView];
    [self.viewModel deleteQuesPart];
}

- (GMButton *)saveButton {
    if (!_saveButton) {
        _saveButton = [GMButton buttonWithType:UIButtonTypeCustom];
        _saveButton.layer.cornerRadius = 22.5;
        _saveButton.layer.masksToBounds = YES;
        _saveButton.titleLabel.font = [UIFont gmBoldFont:17];
        [_saveButton setTitle:@"保存" forState:UIControlStateNormal];
        [_saveButton setTitleColor:UIColor.whiteColor forState:UIControlStateNormal];
        [_saveButton setBackgroundColor:RGBCOLOR_HEX(0xFF8C8D) forState:UIControlStateNormal];
        [_saveButton addTarget:self action:@selector(save) forControlEvents:UIControlEventTouchUpInside];
    }
    return _saveButton;
}

- (GMButton *)deleteButton {
    if (!_deleteButton) {
        _deleteButton = [GMButton buttonWithType:UIButtonTypeCustom];
        _deleteButton.layer.borderWidth = 1.5;
        _deleteButton.layer.borderColor = RGBCOLOR_HEX(0xFF8C8D).CGColor;
        _deleteButton.layer.cornerRadius = 22.5;
        _deleteButton.layer.masksToBounds = YES;
        _deleteButton.titleLabel.font = [UIFont gmBoldFont:17];
        [_deleteButton setTitle:@"删除" forState:UIControlStateNormal];
        [_deleteButton setTitleColor:RGBCOLOR_HEX(0xFF8C8D) forState:UIControlStateNormal];
        [_deleteButton addTarget:self action:@selector(deleteButtonClick) forControlEvents:UIControlEventTouchUpInside];
    }
    return _deleteButton;
}

- (GMEditQuesPartCell *)sectionTagCell {
    if (!_sectionTagCell) {
        _sectionTagCell = [GMEditQuesPartCell new];
        _sectionTagCell.type = GMEditQuesPartTypeSectionTag;
        _sectionTagCell.desc = self.viewModel.editModel.sectionTag.name;
    }
    return _sectionTagCell;
}

- (GMEditQuesPartCell *)improveAppealCell {
    if (!_improveAppealCell) {
        _improveAppealCell = [GMEditQuesPartCell new];
        _improveAppealCell.type = GMEditQuesPartTypeImproveAppeal;
        _improveAppealCell.desc = self.viewModel.editModel.improveAppealNamesStr;
    }
    return _improveAppealCell;
}

- (GMEditQuesPartCell *)suitProjectCell {
    if (!_suitProjectCell) {
        _suitProjectCell = [GMEditQuesPartCell new];
        _suitProjectCell.type = GMEditQuesPartTypeSuitProject;
        _suitProjectCell.desc = self.viewModel.editModel.suitProjectNamesStr;
    }
    return _suitProjectCell;
}

- (GMEditQuesSuggestCell *)otherSuggestionsCell {
    if (!_otherSuggestionsCell) {
        _otherSuggestionsCell = [GMEditQuesSuggestCell new];
        _otherSuggestionsCell.textView.text = self.viewModel.editModel.otherSuggestions;
    }
    return _otherSuggestionsCell;
}

- (GMEditQuesPartSelectView *)selectView {
    if (!_selectView) {
        _selectView = [GMEditQuesPartSelectView new];
        _selectView.pageCtrl = self;
        _selectView.selectDelegate = self;
    }
    return _selectView;
}

@end
