//
//  GMGrabedListViewController.m
//  Gengmei
//
//  Created by Jessica on 2020/3/6.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMGrabedListViewController.h"
#import "GMGrabedListCell.h"
//#import "GMFooterView.h"
@interface GMGrabedListViewController ()

@end

@implementation GMGrabedListViewController

@dynamic viewModel;

- (void)initController{
    [super initController];
    self.viewModel = [GMGrabedListViewModel new];
    self.immediateLoad = NO;
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self headerRereshing];
}

- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor = UIColor.whiteColor;

    _table.estimatedRowHeight = 75;
    [self hideNavigationBar];
    [_table registerClass:[GMGrabedListCell class] forCellReuseIdentifier:NSStringFromClass([GMGrabedListCell class])];
    [_table mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.right.left.bottom.mas_equalTo(0);
        make.top.mas_equalTo(0);
    }];
    _table.contentInset = UIEdgeInsetsMake(12, 0, 0, 0);
}

- (void)configureDataForLikeCell: (GMGrabedListCell *)cell atIndexPath: (NSIndexPath *)indexPath {
    GMDispatchWaitingGrabObject *object = self.viewModel.dataArray[indexPath.row];
    cell.infoView.locationLabel.text = object.cityText;
    cell.infoView.infoLabel.text = object.userContent;
    cell.infoView.projectLabel.text = object.projectContent;
    [cell updateCellConstraints];
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.viewModel.dataArray.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
    GMGrabedListCell *cell = [tableView dequeueReusableCellWithIdentifier:NSStringFromClass([GMGrabedListCell class]) forIndexPath:indexPath];
    __weak __typeof(self)weakSelf = self;
    [weakSelf configureDataForLikeCell:cell atIndexPath:indexPath];
    return cell;
}

@end
