//
//  GMDiagnosisWorkingTableViewModel.h
//  Gengmei
//
//  Created by Jessica on 2020/2/18.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMWorkTableObject.h"
#import "GMDiagnosisWorkingTableSwitch.h"

NS_ASSUME_NONNULL_BEGIN

@interface GMDiagnosisWorkingTableViewModel : WMFetchDataViewModel
@property(nonatomic, strong)GMWorkTableObject *workTableObject;
@property(nonatomic, copy)NSString *doctorId;
@property (nonatomic, strong) NSMutableArray *tagIds;


// 医生面诊开启或关闭
- (void)startConsultationWithSuccessBlock:(HttpSuccessBlock)successBlock failBlock:(HttpFailedBlock)failBlock;
// 关闭
- (void)stopConsultationWithSuccessBlock:(HttpSuccessBlock)successBlock failBlock:(HttpFailedBlock)failBlock;

// 获取tags
- (void)getAllTagsWithSuccessBlock:(HttpSuccessBlock)successBlock failBlock:(HttpFailedBlock)failBlock;

// 获取工作台数据
- (void)fetchWorkBenchHomeData:(void(^)(APIStatusCode, NSString *))block;

@end

NS_ASSUME_NONNULL_END
