//
//  GMPlayBackWelfareView.m
//  Gengmei
//
//  Created by yefengming on 2020/2/22.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMPlayBackWelfareView.h"
#import "GMPlayBackWelfareCell.h"
#import "GMToFaceCommonEmptyView.h"

@interface GMPlayBackWelfareView ()<UITableViewDelegate, UITableViewDataSource>
@property (nonatomic, strong) GMTableView *tableView;
@property (nonatomic, strong)GMToFaceCommonEmptyView *emptyView;
@property (nonatomic, strong) GMButton *closeBtn;
@end

@implementation GMPlayBackWelfareView

- (void)setup {
    [super setup];
    self.container.size = CGSizeMake(MAINSCREEN_WIDTH, MAINSCREEN_HEIGHT * 0.5);
    _tableView = [[GMTableView alloc] init];
    _tableView.backgroundColor = UIColor.whiteColor;
    _tableView.showsHorizontalScrollIndicator = NO;
    _tableView.showsVerticalScrollIndicator = NO;
    _tableView.bounces = NO;
    [_tableView registerCell:[GMPlayBackWelfareCell class]];
    _tableView.dataSource = self;
    _tableView.delegate = self;
    [self.container addSubview:_tableView];
    [_tableView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.mas_equalTo(0);
    }];
    
    _closeBtn = [[GMButton alloc] init];
    [_closeBtn setImage:[UIImage imageNamed:@"play_back_welfare_close"] forState:UIControlStateNormal];
    [_closeBtn setImage:[UIImage imageNamed:@"play_back_welfare_close"] forState:UIControlStateHighlighted];
    [self.container addSubview:_closeBtn];
    [_closeBtn addTarget:self action:@selector(closeBtnClick) forControlEvents:UIControlEventTouchUpInside];
    [_closeBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(20);
        make.right.mas_equalTo(-20);
    }];
    
    _emptyView = [[GMToFaceCommonEmptyView alloc] initWithFrame:CGRectZero];
    _emptyView.hidden = YES;
    _emptyView.emptyLabel.text = @"你的推荐带空空如也";
    [self.container addSubview:_emptyView];
    [_emptyView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(100);
        make.right.mas_equalTo(-100);
        make.height.mas_equalTo(MAINSCREEN_HEIGHT * 0.3);
        make.centerY.mas_equalTo(0);
    }];
    [self.container containerRectCorner:CGSizeMake(5, 5) byRoundingCorners:UIRectCornerTopRight | UIRectCornerTopLeft];
}

- (void)closeBtnClick {
    [self hide];
}

- (void)setDataArr:(NSMutableArray *)dataArr {
    _dataArr = dataArr;
    self.emptyView.hidden = self.dataArr.count;
    self.closeBtn.hidden = self.dataArr.count;
    [self.tableView reloadData];
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    GMPlayBackWelfareCell *cell = [_tableView dequeueCell:[GMPlayBackWelfareCell class] forIndexPath:indexPath];
    cell.welfareObject = self.dataArr[indexPath.row];
    return cell;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.dataArr.count;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    return 112;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    GMWelfareServiceObject *obj = self.dataArr[indexPath.row];
    if ([self.delegate respondsToSelector:@selector(didSelectedWelfareView:obj:)]) {
        [self.delegate didSelectedWelfareView:self obj:obj];
    }
}

@end
