//
//  GMVideoPlayBackToolBar.m
//  Gengmei
//
//  Created by yefengming on 2020/2/20.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMVideoPlayBackToolBar.h"
#import "GMLiveLikeView.h"
#import <SDWebImage/UIImage+GIF.h>
@interface GMVideoPlayBackToolBar ()
@property (nonatomic, strong) GMLiveLikeView * heartFlyView;
@property (nonatomic, strong) GMView *beijingView;
@end

@implementation GMVideoPlayBackToolBar

- (void)setup {
    [super setup];
    
    _beijingView = [[GMView alloc] init];
    _beijingView.backgroundColor = [UIColor whiteColor];
    _beijingView.alpha = 0.2;
    [self addSubview:_beijingView];
    
    _playButton = [GMButton buttonWithType:UIButtonTypeCustom];
    _playButton.userInteractionEnabled = YES;
    _playButton.enableAdaptive = YES;
    [_playButton setBackgroundColor:[UIColor clearColor] forState:UIControlStateNormal];
    [_playButton setBackgroundImage:[UIImage imageNamed:@"play_back_process_button"] forState:UIControlStateSelected];
    [_playButton setBackgroundImage:[UIImage imageNamed:@"play_back_process_pause"] forState:UIControlStateNormal];
    [_playButton addTarget:self action:@selector(clickPlayVideo:) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:_playButton];
    
    _processLabel = [[GMLabel alloc] init];
    _processLabel.font = [UIFont gmFont:14];
    _processLabel.textColor = [UIColor whiteColor];
    [self addSubview:_processLabel];
    
    _processBeginLabel = [[GMLabel alloc] init];
    _processBeginLabel.font = [UIFont gmFont:14];
    _processBeginLabel.textColor = [UIColor whiteColor];
    [self addSubview:_processBeginLabel];

    _processSlider = [[UISlider alloc] init];
    [_processSlider setThumbImage:[UIImage imageNamed:@"play_back_slider"] forState:UIControlStateNormal];
    _processSlider.maximumTrackTintColor = [RGBCOLOR_HEX(0xffffff) colorWithAlphaComponent:0.6];
    _processSlider.minimumTrackTintColor = [UIColor whiteColor];
    [self addSubview:_processSlider];
    [_processSlider addTarget:self action:@selector(willChangeProcessValue:) forControlEvents:UIControlEventTouchDown];
    [_processSlider addTarget:self action:@selector(changeProcessValue:) forControlEvents:UIControlEventValueChanged];
    [_processSlider addTarget:self action:@selector(finishChangeProcessValue:) forControlEvents:UIControlEventTouchUpInside];
    
    [_playButton mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(12);
        make.size.mas_equalTo(CGSizeMake(17, 20));
        make.centerY.mas_equalTo(0);
    }];
    
    [_processBeginLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(_playButton.mas_right).offset(10);
        make.centerY.mas_equalTo(0);
    }];
    
    [_processSlider mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(_processBeginLabel.mas_right).offset(10);
        make.right.mas_equalTo(_processLabel.mas_left).offset(-10);
        make.centerY.mas_equalTo(0);
    }];
    
    [_processLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(_processSlider.mas_right).offset(10);
        make.right.mas_equalTo(-12);
        make.centerY.mas_equalTo(0);
    }];
    
    [_beijingView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.mas_equalTo(0);
    }];
    
    _processBeginLabel.text = @"00:00:00";
    _processLabel.text = @"00:00:00";
}


- (void)clickPlayVideo:(GMButton *)button {
    if ([self.delegate respondsToSelector:@selector(didCilckedPlayVedio:)]) {
        [self.delegate didCilckedPlayVedio:button];
    }
}

- (void)willChangeProcessValue:(UISlider *)slider {
    if ([self.delegate respondsToSelector:@selector(willChangeSliderValue)]) {
        [self.delegate willChangeSliderValue];
    }
}

- (void)changeProcessValue:(UISlider *)slider {
    if ([self.delegate respondsToSelector:@selector(changeSliderValue:)]) {
        [self.delegate changeSliderValue:(CGFloat)slider.value];
    }
}

- (void)finishChangeProcessValue:(UISlider *)slider {
    if ([self.delegate respondsToSelector:@selector(finishChangeSliderValue)]) {
        [self.delegate finishChangeSliderValue];
    }
}

@end
