//
//  NSBundle+GMAILab.m
//  Pods
//
//  Created by cfy on 2020/4/30.
//
#import "NSBundle+GMAILab.h"

@implementation NSBundle (GMAILab)

+ (instancetype)gm_AILabBundle:(Class)className {
    static NSBundle *bundle = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        bundle = [NSBundle gm_AILabBundleBundle:className];
    });
    return bundle;
}

+ (NSBundle *)gm_AILabBundleBundle:(Class)className {
    return [self bundleWithURL:[self gm_AILabBundleURL:className]];
}

+ (NSURL *)gm_AILabBundleURL:(Class)className {
    NSBundle *bundle = [NSBundle bundleForClass:className];
    return [bundle URLForResource:@"GMAILab" withExtension:@"bundle"];
}

@end
