//
//  GMBaseTool.m
//  GMBase
//
//  Created by 卢悦明 on 2020/5/13.
//

#import "GMBaseTool.h"
#import <UserNotifications/UserNotifications.h>

@implementation GMBaseTool
+ (UIViewController *)getRootViewController{

    UIWindow* window = [[[UIApplication sharedApplication] delegate] window];
    return window.rootViewController;
}


+ (UIViewController *)getCurrentViewController{

    UIViewController* currentViewController = [self getRootViewController];

    if (currentViewController.presentedViewController) { //present
        currentViewController = currentViewController.presentedViewController;
        return currentViewController;
    } else if ([currentViewController isKindOfClass:NSClassFromString(@"WMMainTabBarViewController")]) { //一级页面
        UIViewController *vc =  (UIViewController *)[currentViewController valueForKey:@"current"];
        return vc;
    } else {
        UINavigationController* navigationController = (UINavigationController* )currentViewController;
        currentViewController = navigationController.visibleViewController;
        return currentViewController;
    }
}


 //获取当前window
+ (UIWindow *)mainWindow
{
    UIApplication *app = [UIApplication sharedApplication];
    if ([app.delegate respondsToSelector:@selector(window)]) {
        return [app.delegate window];
    } else {
        return [app keyWindow];
    }
}


+ (GMNavigationController *)getNavigation {
    UIViewController* rootVC = [self getRootViewController];

    if ([rootVC isKindOfClass:[GMNavigationController class]]) {
        return (GMNavigationController *)rootVC;
    } else {
        return nil;
    }
}

#pragma mark - 判断用户是否允许推送
+ (void)userIsAllowPush:(void (^)(BOOL))isOpenPushBlock {
    if (@available(iOS 10.0, *)) {
        [[UNUserNotificationCenter currentNotificationCenter] getNotificationSettingsWithCompletionHandler:^(UNNotificationSettings * _Nonnull settings) {
            dispatch_async(dispatch_get_main_queue(), ^{
                if (settings.authorizationStatus == UNAuthorizationStatusNotDetermined){
                    //未选择---没有选择允许或者不允许，按不允许处理
                    isOpenPushBlock(NO);
                } else if (settings.authorizationStatus == UNAuthorizationStatusDenied){
                    //未授权--不允许推送
                    isOpenPushBlock(NO);
                } else if (settings.authorizationStatus == UNAuthorizationStatusAuthorized){
                    //已授权--允许推送
                    isOpenPushBlock(YES);
                }
            });
           
        }];
    } else {
        dispatch_async(dispatch_get_main_queue(), ^{
             UIUserNotificationSettings *settings = [[UIApplication sharedApplication] currentUserNotificationSettings];
                   BOOL isAllow = (settings.types != UIUserNotificationTypeNone);
                   isOpenPushBlock(isAllow);
        });
    }
    
}
@end
