//
//  GMHTTPSessionManager.m
//  Gengmei
//
//  Created by wangyang on 1/15/15.
//  Copyright (c) 2015 Wanmeichuangyi. All rights reserved.
//

#import "GMHTTPSessionManager.h"

@implementation GMHTTPSessionManager

+ (instancetype)shareInstanceWithApiHost:(NSString *)apiHost {
    static dispatch_once_t onceToken;
    static GMHTTPSessionManager *instance = nil;
    dispatch_once(&onceToken, ^{
        NSURL *baseURL = [NSURL URLWithString:apiHost];
        instance = [[[self class] alloc] initWithBaseURL:baseURL];
        instance.responseSerializer.acceptableContentTypes = [NSSet setWithObjects:@"application/json", @"text/json", @"text/javascript", @"text/html", nil];
    });
    return instance;
}



@end
