//
//  OCEmptyView.m
//  Gengmei
//
//  Created by wangyang on 16/7/9.
//  Copyright © 2016年 更美互动信息科技有限公司. All rights reserved.
//

#import "OCEmptyView.h"
#import "GMBaseUtil.h"
#import <Masonry/Masonry.h>

@implementation OCRedGradientButton

-(id)init
{
    self = [super init];
    if (self) {
        self.clipsToBounds = YES;
    }
    return self;
}

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        self.clipsToBounds = YES;
    }
    return self;
}



- (void)layoutSubviews{
    [super layoutSubviews];
    self.layer.cornerRadius = MIN(self.frame.size.height, self.frame.size.width)/2;
}

- (void)drawRect:(CGRect)rect{
        NSArray *colors = @[[UIColor colorWithRed:1 green:89.0/255 blue:99.0/255 alpha:1],[UIColor colorWithRed:1 green:112.0/255 blue:150.0/255 alpha:1]];
        NSMutableArray *ar = [NSMutableArray array];
        for(UIColor *c in colors) {
            [ar addObject:(id)c.CGColor];
        }
        UIGraphicsBeginImageContextWithOptions(self.frame.size, YES, 1);
        CGContextRef context = UIGraphicsGetCurrentContext();
        CGContextSaveGState(context);
        CGColorSpaceRef colorSpace = CGColorGetColorSpace([[colors lastObject] CGColor]);
        CGGradientRef gradient = CGGradientCreateWithColors(colorSpace, (CFArrayRef)ar, NULL);
        
        CGPoint start = CGPointMake(self.frame.size.width, 0.0);
        CGPoint end = CGPointMake(0, self.frame.size.height);
        CGContextDrawLinearGradient(context, gradient, start, end, kCGGradientDrawsBeforeStartLocation | kCGGradientDrawsAfterEndLocation);
        UIImage *image = UIGraphicsGetImageFromCurrentImageContext();
        CGGradientRelease(gradient);
        CGContextRestoreGState(context);
        CGColorSpaceRelease(colorSpace);
        UIGraphicsEndImageContext();
        [self setBackgroundImage:image forState:UIControlStateNormal];
        [self setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
}

@end



@implementation OCEmptyView

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setup];
    }
    return self;
}

- (void)awakeFromNib{
    [super awakeFromNib];
    [self setup];
}

- (void)setup{
    self.backgroundColor = [UIColor whiteColor];
    _tipIcon = [UIImageView new];
    _tipLabel = [UILabel new];
    _tipButton = [OCRedGradientButton buttonWithType:UIButtonTypeCustom];
    _tipButton.frame = CGRectMake(0, 0, 10, 10); //给一个默认的rect，让系统调用DrawRect方法
    [self addSubview:_tipIcon];
    [_tipIcon addSubview:_tipLabel];
    [self addSubview:_tipButton];

    _tipLabel.numberOfLines = 2;
    _tipLabel.preferredMaxLayoutWidth = 160;
    _tipLabel.textColor = [UIColor colorWithhex:0x666666];
    _tipLabel.font = [UIFont navigationFontWithSize:15];
    _tipLabel.textAlignment = NSTextAlignmentCenter;

    _tipButton.hidden = YES;
    [_tipButton setTitle:@"重新加载" forState:UIControlStateNormal];
    _tipButton.titleLabel.font = [UIFont navigationFontWithSize:16];
    [_tipButton setTitleColor:[UIColor colorWithhex:0x666666] forState:UIControlStateNormal];
    [_tipButton addTarget:self action:@selector(reloadBtnTap) forControlEvents:UIControlEventTouchUpInside];

}



- (void)setType:(OCEmptyViewType)type{
    _type = type;
    switch (self.type) {
        case OCEmptyViewTypeEmpty:{
            _tipButton.hidden = YES;
            _tipIcon.image = [UIImage imageNamed:@"empty"];
            _tipLabel.text = @"此处太寂寥，社区等你撩";
            break;
        }
        case OCEmptyViewTypeException:{
            _tipButton.hidden = NO;
            _tipIcon.image = [UIImage imageNamed:@"network_failed"];
            _tipLabel.text = @"原谅我一看到美人就不淡定";
        }
        default:
            break;
    }
}



- (void)layoutSubviews {
    [super layoutSubviews];
    if (_tipImage.length > 0) {
        _tipIcon.image = [UIImage imageNamed:_tipImage];
    }
    if (_tipText.length > 0) {
        _tipLabel.text = _tipText;
    }
}


- (void)updateConstraints{
    [super updateConstraints];
    [_tipIcon mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self);
        make.centerY.equalTo(self).offset(-75);
//        make.size.mas_equalTo(CGSizeMake(175, 198));
    }];
    [_tipLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.bottom.equalTo(_tipIcon.mas_bottom).offset(-18);
        make.centerX.mas_equalTo(self);
    }];
    [_tipButton mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(_tipIcon.mas_bottom).offset(15);
        make.centerX.equalTo(self);
        make.width.mas_equalTo(150);
        make.height.mas_equalTo(33);
    }];
}


- (void)reloadBtnTap {
    if ([self.delegate respondsToSelector:@selector(emptyViewDidClickReload)]) {
        [self.delegate emptyViewDidClickReload];
    }
}
@end

