//
//  OCNavigationBar.h
//  Pods
//
//  Created by wangyang on 16/7/8.
//  Copyright © 2016年 更美互动信息科技有限公司. All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN
@class OCNavigationBarButton;
@protocol OCNavigationBarDelegate <NSObject>
- (void)rightButtonClicked:(OCNavigationBarButton *)button;
- (void)nearRightButtonClicked:(OCNavigationBarButton *)button;
- (void)backAction:(OCNavigationBarButton *)button;
@end

/**
 *  @author wangyang
 *
 *  作为单独组件后，导航栏按键具体值应该由业务层控制。这里不再关心
 */
@interface OCNavigationBar : UIView
@property (nonatomic, weak) id<OCNavigationBarDelegate> delegate;
// OCNavigationBar 高度是64，itemView的y坐标从20开始，高44。titleLabel，titleView，backButton，rightButton，nearRightButton都是被添加到该itemView中的
@property (nonatomic, strong, readonly) UIView *itemView;
@property (nonatomic, strong, readonly) UILabel *titleLabel;

// 就像系统导航栏的titleView的用法
@property (nonatomic, strong, nullable) UIView *titleView;
@property (nonatomic, copy, nullable) NSString *title;

@property (nonatomic, strong, readonly) OCNavigationBarButton *leftButton;
@property (nonatomic, strong, readonly) OCNavigationBarButton *rightButton;
@property (nonatomic, strong, readonly) OCNavigationBarButton *nearRightButton;

/**
 leftIcon 有默认值：back
 */
@property (nonatomic, copy, nullable) NSString *leftIcon;
@property (nonatomic, copy, nullable) NSString *rightIcon;
@property (nonatomic, copy, nullable) NSString *nearRightIcon;

@property (nonatomic, copy, nullable) NSString *leftTitle;
@property (nonatomic, copy, nullable) NSString *rightTitle;
@property (nonatomic, copy, nullable) NSString *nearRightTitle;

/**
 由h5 pagedata中传递过来的right_button
 */
@property (nonatomic, copy, nullable) NSString *nearRightIconURL;
@property (nonatomic, copy, nullable) NSString *rightIconURL;

/// 默认显示阴影（严格来说是一条线，并不是阴影）
- (void)showShadow:(BOOL)show;
- (void)hideAllItems;
@end

@interface OCNavigationBar (ViewConstant)

/**
 OCNavigationBar的高度
 */
@property (nonatomic, readonly, class) CGFloat barHeight;

/**
 电池栏的高度
 */
@property (nonatomic, readonly, class) CGFloat statusBarHeight;

/**
 OCNavigationBar中，item的centerY
 */
@property (nonatomic, readonly, class) CGFloat navigationItemCenterY;
@end

@interface OCNavigationBarButton : UIButton

@end

NS_ASSUME_NONNULL_END
