//
//  UIViewController+Phobos.h
//  Pods
//
//  Created by wangyang on 16/7/12.
//
//

#import <UIKit/UIKit.h>

@interface UIViewController (Phobos)
/**
 *  @author 翟国钧, 16-02-24 17:02:22
 *
 *  @brief 埋点的时候，有些埋点都需要业务id，比如DoctorId，针对那些只能在父类中埋点的业务，要在子类中设置当前id，然后在父类中取到
 *  在一些详情页的分享和收藏的时候，由于分享、收藏的方法在basewebview里，所以，统一在里面做处理，但是需要在子类中把想要的参数传过去。包括：type（类型）、from（来自哪）、businessId（对应业务id）
 *  @since 5.9.1
 */
@property (nonatomic, copy, nonnull) NSString *businessId;

/**
 *  @author 翟国钧  in 16-02-25 19:02:32
 *
 *  @brief 获取前一个页面的pageName
 *
 *  @since 5.9.1
 */
@property (nonatomic, strong, readonly, nonnull) NSString *referer;

/**
 *  @author 翟国钧 in 16-02-25 19:02:32
 *
 *  埋点pv事件中当前页面的别名
 *  @since 5.9.1
 */
@property (nonatomic, copy, nonnull) NSString *pageName;

/**
 当前VC.view 显示的时候的时间戳
 @author zhaiguojun 16-10-12 in (null)
 */
@property (nonatomic, copy, nonnull) NSString *inTime;

@end
