//
//  GMBaseWebViewController.h
//  ZhengXing
//
//  Created by wangyang on 3/5/19.
//  Copyright (c) 2019 Wanmei Creative. All rights reserved.
//  后期替代WMBaseViewController&WMBrowserViewController
@import GMShareSDK;
//#import <GMShareSDK/GMShareSDK.h>
#define kWebPhantom         @"phantom"// 常用于H5新页面
#define kWebHybrid          @"hybrid" // 常用于H5老页面
//#import <GMShareSDK/GMShareView.h>
////#import "GMShareView.h"
//#import <GMShareSDK/WMShareObject.h>
//#import <GMShareSDK/GMDiaryShareView.h>
//#import <GMShareSDK/GMClientH5Object.h>
#import "GMWebViewModel.h"

typedef NS_ENUM(NSInteger, GMWebPageType) {
    GMWebPageTypeNomal            = 0,
    GMWebPageTypeSign             = 1, // 签到H5页面
    GMWebPageTypeTopicDetail      = 2,// 日记贴
    GMWebPageTypeAnswer           = 3,// 回答
    GMWebPageTypeArticle          = 4,// 话题
    GMWebPageTypeSpecial          = 5,// 专栏
    GMWebPageTypeUserTopic        = 6,// 用户贴
    GMWebPageTypeQuestion         = 7,// 回答 7.20 灰度用
    GMWebPageTypeHospitalRank     = 8,// 医院榜单
    GMWebPageTypeDoctorRank       = 9,// 医生榜单
};

@import GMKit;
@class GMWebViewComponent;
@interface GMBaseWebViewController : WMBaseViewController<GMClientH5BridgeDelegate> {
    /**
     *  @brief   下面都是从js中得到的数据。其中_jsGlobalObject字典包含其它数据
     */
    NSDictionary *_jsGlobalObject;

    // 是否显示了分享
    BOOL _isShowShare;
    // 是否收藏
    BOOL _isFavored;
    // 是否是自己发的贴
    BOOL _isPrivate;
    
    // 是否是签到，签到导航栏透明，返回按钮、title颜色、rightIcon单独设置
    BOOL _isSign;
}

@property (nonatomic, strong) GMWebViewComponent *webCompent;

/// web上数据处理
@property (nonatomic, strong) GMWebViewModel *viewModel;
/**
 *  @brief  要请求的 H5 url 除了 http://backend.dev.gengmei.cc/hybrid" 这部分后的path。比如一个h5是 http://backend.dev.gengmei.cc/hybrid/topic/3332214，那么path指需要赋值@"/topic/3332214"即可.
 @note 在viewDidLoad前配置好。必须以"/"开头。重写moreQueryParameters可以添加额外query
 */
@property (nonatomic, strong) NSString *path;

/**
 *  @brief  对于从服务器那儿获取到的完整H5 url，使用该属性。
 @note 在viewDidLoad前配置好。会覆盖path属性。重写moreQueryParameters可以添加额外query
 */
@property (nonatomic, strong) NSString *fullURL;

/// 通过webPageType 页面不同设置不同的差异性
@property (nonatomic, assign) GMWebPageType webPageType;

#pragma mark - 分享

@property (nonatomic, strong) GMShareView *shareView;

@property (nonatomic, strong) GMDiaryShareView *diaryShareView;

/***  @brief  收藏url**/
@property (nonatomic,strong) NSString *favUrl;

/***  @brief  从_jsGlobalObject中获取的分享Model */
@property (nonatomic, strong) WMShareObject *shareObject;

/***  @brief  日记分享Model数组 */
@property (nonatomic, strong) NSMutableArray *diaryShareArr;

/***  @brief  微信分享Model */
@property (nonatomic, strong) WMShareObject *weixinShareObject;

/***  @brief  分享的配置 */
@property (nonatomic, strong) GMShareConfigObject *shareConfigObject;

@property (nonatomic , strong) NSString *favorType;

/**
 设置打开的权限类型
 */
@property (nonatomic, assign) NSInteger settingType;


@property (nonatomic, assign) BOOL backNeedRefresh;

/**
 *  @brief  重写该方法，为fullURL在请求前添加更多参数。必须以 & 开头
 *  原方法只返回了空字符串，不需要call super
 *
 *  @return 要额外添加的参数。如：&key1=value&key2=value
 */
- (NSString *)moreQueryParameters;

/**
 调用该方法以重新构造URL并且[_webView loadRequest:request];
 */
- (void)reloadURL;
/**
处理请求URL
*/
- (void)handleURL;

// 一般情况下 页面刷新时候调用
- (void)refreshWebView;

// 本地获取通用数据
- (NSString *)nativeCommonParam;

@end
