//
//  Phobos.h
//  GengmeiDoctor
//  Data Statistic Client For Mars
//  Created by Thierry on 16/1/26.
//  Copyright © 2016年 wanmeizhensuo. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface Phobos : NSObject

@property (strong, nonatomic) UINavigationController *selectedNavigationController;


/**
 *  @brief 开启Phobos统计,默认以BATCH方式发送log.
 *
 *  @param appName
 *  @param channelId
 *
 *  @return
 *
 *  @since 0.0.1
 */
+ (Phobos *)clientWithAppName:(NSString *)appName channelId:(NSString *)channelId;

+ (instancetype)sharedClient;

+ (void)setSharedClient:(Phobos *)client;


/**
 *  @brief 设置是否打印sdk的log信息,默认不开启
 *
 *  @param value 设置为YES,phobos SDK 会输出log信息,记得release产品时要设置回NO.
 *
 *  @since 0.0.1
 */
- (void)setLogEnabled:(BOOL)value;

/**
 *  @brief 设置当前登录用户的ID，如果没有默认为@""
 *
 *  @param userId
 *
 *  @since 0.0.2
 */
- (void)setUserId:(NSInteger)userId;

/*!
 *  @author zhaiguojun, 16-05-31
 *
 *  @brief 用户当前的城市id
 *
 *  @param currentCityId
 *
 *  @since 0.2.7
 */
- (void)setCurrentCityId:(NSString *)currentCityId;

- (void)setGPS:(NSDictionary *)gps;

/**
 *  @brief 自定义事件,数量统计.
 *
 *  @param eventId 事件Id
 *  @attributes 参数
 *  @sendNow 是否实时发送，默认为NO
 *
 *  @since 0.0.1
 */
+ (void)track:(NSString *)eventId attributes:(NSDictionary *)attributes;
+ (void)track:(NSString *)eventId attributes:(NSDictionary *)attributes sendNow:(BOOL)sendNow;
+ (void)track:(NSString *)eventId;
/**
 *  @author 翟国钧, 16-02-03 16:02:30
 *
 *  @brief H5调用的埋点方法
 *
 *  @param jsonString h5传过来的参数
 *
 *  @since 0.0.1
 */
+ (void)trackJsEvent:(NSString *)jsonString;

/**
 *  @brief 当页面加载时的PV处理
 *
 *  @param pageName   页面唯一编码
 *  @param businessId 页面中的业务ID，比如美购详情页美购ID
 *  @param refererPageName 目标页面的上一个页面的pageName
 *
 *  @since 0.0.8
 */
- (void)onPageStart:(NSString *)pageName businessId:(NSString *)businessId referer:(NSString *)refererPageName inTime:(NSString *)time;

/**
 *  @brief 当页面结束时的PV处理，在此方法中记录当前页面的停留时间和记录本次埋点事件
 *
 *  @since 0.0.8
 */
- (void)onPageEnd:(NSString *)pageName businessId:(NSString *)businessId referer:(NSString *)refererPageName inTime:(NSString *)time;

/**
 *  @author 翟国钧, 16-03-08 11:03:45
 *
 *  @brief 有些事件需要模拟pv事件，统一用该方法处理，in out 时间相同.点击一次即触发
 *
 *  @param pageName 控件所在VC的pageName
 *  @param bid      业务id
 *  @param referer  上个月面的pagename
 *
 *  @since 5.9.1
 */
- (void)simulativePageViewEventWithPageName:(NSString *)pageName BusinessId:(NSString *)bid referer:(NSString *)referer;

@end
