//
//  GMRefreshFooter.m
//  GengmeiDoctor
//
//  Created by Terminator on 16/4/29.
//  Copyright © 2016年 wanmeizhensuo. All rights reserved.
//

#import "GMRefreshFooter.h"
#import "GMRefreshConstant.h"

@interface GMRefreshFooter()
@property (nonatomic, strong) UIImageView *prepareImageView;
@end
@implementation GMRefreshFooter

- (void)prepare
{
    [super prepare];
    //隐藏文字显示
    self.refreshingTitleHidden = YES;
    self.stateLabel.hidden = YES;
    // 设置正在刷新状态的动画图片
    NSMutableArray *refreshingImages = [NSMutableArray array];
    for (NSUInteger i = 1; i<=20; i++) {
        NSString *imageName = [NSString stringWithFormat:@"pullLoading%ld", i];
        NSString *imagePath = GMRefreshImageName(imageName);
        UIImage *image = [UIImage imageNamed:imagePath];
        [refreshingImages addObject:image];
    }
    [self setImages:refreshingImages forState:MJRefreshStateRefreshing];
}
@end
