//
//  WMBaseViewController+FadeNavigation.m
//  Gengmei
//
//  Created by wangyang on 2017/6/6.
//  Copyright © 2017年 更美互动信息科技有限公司. All rights reserved.
//

#import "WMBaseViewController+FadeNavigation.h"
#import <objc/runtime.h>

@implementation WMBaseViewController (FadeNavigation)
- (void)setAnimationDistance:(CGFloat)animationDistance {
    objc_setAssociatedObject(self, @selector(animationDistance), @(animationDistance), OBJC_ASSOCIATION_RETAIN);
}

- (CGFloat)animationDistance {
    NSNumber *_animationDistance = objc_getAssociatedObject(self, _cmd);
    if (_animationDistance == nil) {
        return 0;
    } else {
        return [_animationDistance doubleValue];
    }
}

- (void)setContentOffsetY:(CGFloat)contentOffsetY {
    objc_setAssociatedObject(self, @selector(contentOffsetY), @(contentOffsetY), OBJC_ASSOCIATION_RETAIN);
}

- (CGFloat)contentOffsetY {
    NSNumber *_contentOffsetY = objc_getAssociatedObject(self, _cmd);
    if (_contentOffsetY == nil) {
        return 0;
    }
    return _contentOffsetY.doubleValue;
}

- (CGFloat)animationBar:(OCNavigationBar *)bar withScrollView:(UIScrollView *)scrollView {
    CGFloat offsetY = scrollView.contentOffset.y;
    
    if (self.contentOffsetY > 0) {
        offsetY = self.contentOffsetY;
    }
    
    CGFloat alpha = MIN(1.0, offsetY / self.animationDistance);
    if (offsetY > self.animationDistance) {
        // 导航栏不透明
        bar.backgroundColor = [UIColor colorWithWhite:1 alpha:alpha];
        bar.titleLabel.textColor = [UIColor colorWithWhite:0 alpha:alpha];
        bar.isShowShadow = YES;
    } else {
        // 导航栏渐变到透明
        bar.backgroundColor = [UIColor colorWithWhite:1 alpha:alpha];
        bar.titleLabel.textColor = [UIColor colorWithWhite:0 alpha:alpha];
        bar.isShowShadow = NO;
    }
    self.navigationBar.titleLabel.hidden = alpha == 0;
    return alpha;
}

@end
