//
//  GMPresentAnimation.m
//  Gengmei
//
//  Created by Terminator on 2017/8/30.
//  Copyright © 2017年 更美互动信息科技有限公司. All rights reserved.
//

#import "GMPresentAnimation.h"
#import "UIViewController+PushType.h"
@interface GMPresentAnimation() <UIViewControllerAnimatedTransitioning>
@property(nonatomic,assign)NSTimeInterval duration;
@end
@implementation GMPresentAnimation

- (instancetype)init
{
    //  默认 push 动画时间0.6
    if (self = [super init]) {
        //        self.duration = 0.6;
        self.duration  = 0.6;
    }
    return self;
}

- (void)push:(id<UIViewControllerContextTransitioning>)transitionContext
{
    UIViewController *fromVC    = [transitionContext viewControllerForKey:UITransitionContextFromViewControllerKey];
    UIViewController *toVC      = [transitionContext viewControllerForKey:UITransitionContextToViewControllerKey];
    NSTimeInterval duration     = [self transitionDuration:transitionContext];
    
    CGRect bound                = [[UIScreen mainScreen] bounds];
    
    fromVC.view.hidden          = YES;
    
    [[transitionContext containerView] addSubview:fromVC.snapshot];
    [[transitionContext containerView] addSubview:toVC.view];
    
    [[toVC.navigationController.view superview] insertSubview:fromVC.snapshot belowSubview:toVC.navigationController.view];
    
    toVC.navigationController.view.layer.anchorPoint = CGPointMake(0.5, 2.0);
    toVC.navigationController.view.frame = bound;
    
    toVC.navigationController.view.transform = CGAffineTransformMakeTranslation(0, CGRectGetHeight(bound));
    
    [UIView animateWithDuration:duration
                          delay:0
         usingSpringWithDamping:1.0
          initialSpringVelocity:0
                        options:UIViewAnimationOptionCurveLinear
                     animations:^{
                         fromVC.snapshot.transform = CGAffineTransformMakeTranslation(0, 0);
                         toVC.navigationController.view.transform = CGAffineTransformMakeTranslation(0, 0);
                     }
                     completion:^(BOOL finished) {
                         fromVC.view.hidden = NO;
                         [fromVC.snapshot removeFromSuperview];
                         [transitionContext completeTransition:YES];
                     }];
    
    
}


- (void)pop:(id<UIViewControllerContextTransitioning>)transitionContext
{
    
    UIViewController * fromVC  = [transitionContext viewControllerForKey:UITransitionContextFromViewControllerKey];
    UIViewController * toVC         = [transitionContext viewControllerForKey:UITransitionContextToViewControllerKey];
    NSTimeInterval duration         = [self transitionDuration:transitionContext];
    CGRect bound                    = [[UIScreen mainScreen] bounds];
    
    
    
    
    [fromVC.view addSubview:fromVC.snapshot];
    fromVC.navigationController.navigationBar.hidden = YES;
    
    //    添加阴影
    fromVC.snapshot.layer.shadowColor = [UIColor colorWithRed:0.2 green:0.2 blue:0.2 alpha:0.8].CGColor;
    fromVC.snapshot.layer.shadowOffset = CGSizeMake(-3, 0);
    fromVC.snapshot.layer.shadowOpacity = 0.5;
    
    fromVC.view.layer.anchorPoint = CGPointMake(0.5, 2.5);
    fromVC.view.frame = bound;
    
    
    toVC.view.hidden                = YES;
    
    [[transitionContext containerView] addSubview:toVC.view];
    [[transitionContext containerView] addSubview:toVC.snapshot];
    [[transitionContext containerView] sendSubviewToBack:toVC.snapshot];
    
 
    [UIView animateWithDuration:duration
                          delay:0
         usingSpringWithDamping:1.0
          initialSpringVelocity:0
                        options:UIViewAnimationOptionCurveLinear
                     animations:^{
                         fromVC.view.transform = CGAffineTransformMakeTranslation(0,  CGRectGetHeight(bound));
                         toVC.snapshot.alpha = 1;
                         
                     }
                     completion:^(BOOL finished) {
                         toVC.navigationController.navigationBar.hidden = NO;
                         toVC.view.hidden = NO;
                         
                         [fromVC.snapshot removeFromSuperview];
                         [toVC.snapshot removeFromSuperview];
                         
                         if (![transitionContext transitionWasCancelled])
                         {
                             toVC.snapshot = nil;
                         }
                         [transitionContext completeTransition:![transitionContext transitionWasCancelled]];
                         
                     }];
    
    
}

- (NSTimeInterval)transitionDuration:(nullable id <UIViewControllerContextTransitioning>)transitionContext
{
    return self.duration;
}

- (void)animateTransition:(id <UIViewControllerContextTransitioning>)transitionContext
{
    if (self.transitionType == UINavigationControllerOperationPush)
    {
        [self push:transitionContext];
    }
    else if (self.transitionType == UINavigationControllerOperationPop)
    {
        [self pop:transitionContext];
    }
}

@end
