//
//  GMFloatWindow.m
//  Gengmei
//
//  Created by licong on 2018/1/25.
//  Copyright © 2018年 更美互动信息科技有限公司. All rights reserved.
//

#import "GMFloatWindow.h"
//#import "GMLoginManager.h"
//#import "UITabBar+ViewConstant.h"
#import "GMFloatWindowProtocol.h"
#import "GMBaseTool.h"

@import GMKit;
@interface GMFloatWindow()<CAAnimationDelegate> {
    UIViewController *_controller;
}
@property (nonatomic, strong) UIPanGestureRecognizer *panGesture;
@end

@implementation GMFloatWindow

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:[UIScreen mainScreen].bounds];
    if (self) {
        self.clipsToBounds = YES;
        self.backgroundColor = [UIColor clearColor];
        _tapGesture = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(expandAction:)];
        _tapGesture.delegate = self;
        _panGesture =[[UIPanGestureRecognizer alloc]initWithTarget:self action:@selector(panAction:)];
        _panGesture.minimumNumberOfTouches = 1;
        _panGesture.maximumNumberOfTouches = 1;
        _panGesture.delegate = self;
        self.isExpanded = YES;
    }
    return self;
}

- (void)showController:(UIViewController *)controller {
    //如果之前已有controller
    if (_controller) {
        [(id<GMFloatWindowProtocol>)_controller destroyOtherController];
        _controller = nil;
    }
    if (self.superview == nil) {
        [[UIApplication sharedApplication].keyWindow addSubview:self];
    }
    _controller = controller;
    [self addSubview:controller.view];
    self.isShowingAnimation = YES;
    if (_isExpanded) {
        //当前没有小浮窗        
        //transform 要设置在前面因为它会印象frame
        self.transform = CGAffineTransformMakeScale(1, 1);
        self.frame = CGRectMake(0, MAINSCREEN_HEIGHT, MAINSCREEN_WIDTH, MAINSCREEN_HEIGHT);
        self.layer.cornerRadius = 0;
        self.hidden = NO;
        [UIView animateWithDuration:0.25 delay:0 options:UIViewAnimationOptionCurveEaseIn animations:^{
            self.top = 0;
        } completion:^(BOOL finished) {
            self.isShowingAnimation = NO;
        }];
    }else {
        //当前已经有小浮窗，需要关闭当前小浮窗，在打开新的浮窗,具体实现其实是换了window的rootCtroller
        //先移除手势
        [self addGestureRecognizer:self.tapGesture];
        [self addGestureRecognizer:self.panGesture];
        //去掉圆角
        self.layer.cornerRadius = 0;
        //window大小还原，将window刚好放在屏幕下面
        self.transform = CGAffineTransformMakeScale(1, 1);
        self.frame = CGRectMake(0, MAINSCREEN_HEIGHT, MAINSCREEN_WIDTH, MAINSCREEN_HEIGHT);
        [UIView animateWithDuration:0.25 delay:0.1 options:UIViewAnimationOptionCurveEaseIn animations:^{
            self.top = 0;
        } completion:^(BOOL finished) {
            self.isShowingAnimation = NO;
        }];
    }
}

- (void)hideWithNoAnimation{
    self.hidden = YES;
    //恢复成默认值
    self.isExpanded = YES;
}

- (void)hide {
    [UIView animateWithDuration:0.25 delay:0 options:UIViewAnimationOptionCurveEaseIn animations:^{
        self.top = MAINSCREEN_HEIGHT;
    } completion:^(BOOL finished) {
        [self hideWithNoAnimation];
        _controller = nil;
    }];
}

- (void)expandAction:(UITapGestureRecognizer *)tapGesture{
    
    [[GMBaseTool getCurrentViewController].view endEditing:YES];
    self.layer.cornerRadius = 0;
    self.hidden = NO;
    [UIView animateWithDuration:0.25f animations:^{
        self.transform = CGAffineTransformMakeScale(1, 1);
        self.frame = CGRectMake(0, 0, MAINSCREEN_WIDTH, MAINSCREEN_HEIGHT);
    } completion:^(BOOL finished) {
        [self removeGestureRecognizer:self.tapGesture];
        [self removeGestureRecognizer:self.panGesture];
    }];
    [(id<GMFloatWindowProtocol>)_controller showOtherViews];
    _isExpanded = YES;
}

-(void)panAction:(UIPanGestureRecognizer *)recognizer {
    UIWindow *window = [UIApplication sharedApplication].keyWindow;
    CGPoint translatedPoint = [recognizer translationInView:window];
    switch (recognizer.state) {
        case UIGestureRecognizerStateBegan:
        {
            break;
        }
        case UIGestureRecognizerStateChanged:
        {
            CGFloat x = recognizer.view.center.x + translatedPoint.x;
            CGFloat y = recognizer.view.center.y + translatedPoint.y;
            if (x < recognizer.view.width / 2.0) {
                x = recognizer.view.width / 2.0;
            } else if (x + recognizer.view.width / 2.0 > MAINSCREEN_WIDTH) {
                x = MAINSCREEN_WIDTH - recognizer.view.width / 2.0;
            }
            
            if (y < recognizer.view.height / 2.0) {
                y = recognizer.view.height / 2.0;
            } else if (y + recognizer.view.height / 2.0> MAINSCREEN_HEIGHT) {
                y = MAINSCREEN_HEIGHT - recognizer.view.height / 2.0;
            }
            recognizer.view.center = CGPointMake(x, y);
            UIWindow *window = [UIApplication sharedApplication].keyWindow;

            [recognizer setTranslation:CGPointMake(0, 0) inView:window];
            break;
        }
        case UIGestureRecognizerStateCancelled:
        case UIGestureRecognizerStateEnded:
        default:
            break;
    }
}

- (void)zoomToSmall {
    if (_controller == nil) {
        return;
    }
    [(id<GMFloatWindowProtocol>)_controller hideOtherViews];
    self.layer.cornerRadius = 18;
    _isExpanded = NO;
    [UIView animateWithDuration:0.25f animations:^{
        self.transform = CGAffineTransformMakeScale(0.28, (MAINSCREEN_WIDTH * 0.28 * 1.78)/MAINSCREEN_HEIGHT);
        self.frame = CGRectMake(MAINSCREEN_WIDTH * 0.72 - 10, 85, MAINSCREEN_WIDTH * 0.28, MAINSCREEN_WIDTH * 0.28 * 1.78);
    } completion:^(BOOL finished) {
        [self addGestureRecognizer:self.tapGesture];
        [self addGestureRecognizer:self.panGesture];
    }];
}

// 视频缩小，宽是屏幕1/4，宽高比3：5
- (void)videoZoomToSmall {
    if (_controller == nil) {
        return;
    }
    [(id<GMFloatWindowProtocol>)_controller hideOtherViews];
    self.layer.cornerRadius = 28;
    _isExpanded = NO;
    [UIView animateWithDuration:0.25f animations:^{
        self.transform = CGAffineTransformMakeScale(0.35, 0.35);
        self.frame = CGRectMake(MAINSCREEN_WIDTH * 0.75, MAINSCREEN_HEIGHT * 0.16, MAINSCREEN_WIDTH * 0.25, MAINSCREEN_WIDTH * 0.417);
    } completion:^(BOOL finished) {
        [self addGestureRecognizer:self.tapGesture];
        [self addGestureRecognizer:self.panGesture];
    }];
}

#pragma mark- Gesture Delagate

- (BOOL)gestureRecognizer:(UIGestureRecognizer *)gestureRecognizer shouldRecognizeSimultaneouslyWithGestureRecognizer:(UIGestureRecognizer *)otherGestureRecognizer{
    return YES;
}

@end
