//
//  UIView+NavigationShadow.m
//  GMBase
//
//  Created by wangyang on 2018/2/23.
//

#import "UIView+NavigationShadow.h"
@import GMKit;
#import <objc/runtime.h>

@interface UIView ()
//@property (nonatomic, strong) UIView *shadowLayer;
@property (nonatomic, strong) CALayer *shadowLayer;
@end

@implementation UIView (NavigationShadow)
- (void)addNavigationShadow {
    self.layer.masksToBounds = NO;
    self.shadowLayer = [CALayer layer];
    self.shadowLayer.bounds = CGRectMake(0, 0, Constant.screenWidth, 12);
    self.shadowLayer.position = CGPointMake(self.bounds.size.width/2, self.bounds.size.height - 6);
    self.shadowLayer.backgroundColor = [UIColor whiteColor].CGColor;
    self.shadowLayer.masksToBounds = NO;
    self.shadowLayer.shadowOpacity = 1.0f;
    self.shadowLayer.shadowRadius = 2.0f;
    self.shadowLayer.shadowOffset = CGSizeMake(0.0, ONE_PIXEL);
    self.isShowShadow = YES;
    CGPathRef path = CGPathCreateWithRect(CGRectMake(0, self.shadowLayer.bounds.size.height - 6, Constant.screenWidth, 6), nil);
    self.shadowLayer.shadowPath = path;
    CGPathRelease(path);
    self.shadowLayer.shadowColor = [UIColor colorWithWhite:0 alpha:0.1].CGColor;
}

- (void)setIsShowShadow:(BOOL)isShowShadow {
    objc_setAssociatedObject(self, @selector(isShowShadow), @(isShowShadow), OBJC_ASSOCIATION_RETAIN_NONATOMIC);
    if (isShowShadow && self.shadowLayer.superlayer == nil) {
        [self.layer insertSublayer:self.shadowLayer atIndex:0];

    } else if (!isShowShadow && self.shadowLayer.superlayer != nil) {
        [self.shadowLayer removeFromSuperlayer];
    }
}

- (BOOL)isShowShadow {
    NSNumber *_isShowShadow = objc_getAssociatedObject(self, @selector(isShowShadow));
    if (_isShowShadow == nil) {
        return 0;
    } else {
        return [_isShowShadow boolValue];
    }
}

- (void)setShadowLayer:(CALayer *)shadowLayer {
    objc_setAssociatedObject(self, @selector(shadowLayer), shadowLayer, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}
- (CALayer *)shadowLayer {
    CALayer *_shadowLayer = objc_getAssociatedObject(self, @selector(shadowLayer));
    if (_shadowLayer == nil) {
        return [CALayer new];
    } else {
        return _shadowLayer;
    }
}

@end
