//
//  UIViewController+NavigationCompletionBlock.m
//  GMBase
//
//  Created by wangyang on 2018/1/25.
//

#import "UIViewController+NavigationCompletionBlock.h"

@implementation UIViewController (NavigationCompletionBlock)
- (void)pushViewController:(UIViewController *)viewController animated:(BOOL)animated completion: (void (^ __nullable)(void))completion {
    [CATransaction setCompletionBlock:completion];
    [CATransaction begin];
    [self.navigationController pushViewController:viewController animated:animated];
    [CATransaction commit];
}

- (nullable UIViewController *)popViewControllerAnimated:(BOOL)animated completion: (void (^ __nullable)(void))completion {
    UIViewController *poppedViewController;
    [CATransaction setCompletionBlock:completion];
    [CATransaction begin];
    poppedViewController = [self.navigationController popViewControllerAnimated:animated];
    [CATransaction commit];
    return poppedViewController;
}

- (nullable NSArray<__kindof UIViewController *> *)popToViewController:(UIViewController * _Nonnull)viewController animated:(BOOL)animated  completion: (void (^ __nullable)(void))completion{
    NSArray<UIViewController*>* viewControllers;
    [CATransaction setCompletionBlock:completion];
    [CATransaction begin];
    viewControllers = [self.navigationController popToViewController:viewController animated:animated];
    [CATransaction commit];
    return viewControllers;
}

- (nullable NSArray<__kindof UIViewController *> *)popToRootViewControllerAnimated:(BOOL)animated   completion: (void (^ __nullable)(void))completion {
    NSArray<UIViewController*>* viewControllers;
    [CATransaction setCompletionBlock:completion];
    [CATransaction begin];
    viewControllers = [self.navigationController popToRootViewControllerAnimated:animated];
    [CATransaction commit];
    return viewControllers;
}

- (void)pushAndKillToRoot:(UIViewController *)controller {
    NSMutableArray *result = [self.navigationController.viewControllers mutableCopy];
    do {
        [result removeLastObject];
    } while (result.count != 1);

    [CATransaction setCompletionBlock:^{
        [result addObject:controller];
        self.navigationController.viewControllers = result;
    }];
    [CATransaction begin];
    [self.navigationController pushViewController:controller animated:YES];
    [CATransaction commit];
}

- (void)push:(UIViewController *)controller andKillTo:(Class)controllerClass further:(NSInteger)count {
    NSMutableArray *result = [self.navigationController.viewControllers mutableCopy];
    do {
        [result removeLastObject];
    } while (![result.lastObject isMemberOfClass:controllerClass] && result.count > 0);

    if (count > 0 && result.count > count) {
        [result removeObjectsInRange:NSMakeRange(result.count - count, count)];
    }

    [CATransaction setCompletionBlock:^{
        [result addObject:controller];
        self.navigationController.viewControllers = result;
    }];
    [CATransaction begin];
    [self.navigationController pushViewController:controller animated:YES];
    [CATransaction commit];
}
@end
