//
//  NetService.h
//  Gengmei
//
//  Created by Thierry on 1/5/15.
//  Copyright (c) 2015 Wanmeichuangyi. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "GMNetConstant.h"

/**
 *  @brief  针对业务的封装
 */
@class GMHTTPSessionManager, WMNetSecurityWorking;

@interface WMNetService : NSObject

/**
 *  @author licong, 15-11-19 19:11:02
 *
 *  初始化时候,下载器时候必须设置好,分别用来HTTP和HTTPS请求,但不负责有关上传的HTTP/HTTPS请求,上传图片用了单独的AFHTTPSessionManager
 *
 *  @since 0.2.3
 */
@property (nonatomic, strong) GMHTTPSessionManager *networking;
/***  @brief  稍安全HTTPS下载器*/
@property (nonatomic, strong) WMNetSecurityWorking *netSecurityworking;
/***  @brief  普通HTTP HOST*/
@property (nonatomic, strong) NSString *apiHost;
/***  @brief  安全HTTPS HOST*/
@property (nonatomic, strong) NSString *apiSecurityHost;

@property (nonatomic, strong) NSString *webHost;
@property (nonatomic, strong) NSString *loginExpiredName;
@property (nonatomic, strong) NSString *urlCommonParameters;
@property (nonatomic, copy) void (^handleResponse) (NSDictionary *response);

+ (instancetype)sharedInstance;
/**
 *  @author licong, 15-11-19 12:11:09
 *
 *  普通HTTP请求
 *
 *  @param URLString  请求URL的path部分，HOST会在内部拼接固定参数
 *  @param parameters 请求参数
 *  @param method     请求方法
 *  @param success    成功后的回调
 *  @param failed     失败后的回调
 *
 *  @since 0.2.2
 */
- (void)sendRequestWithURLString:(NSString *)URLString
                      parameters:(id)parameters
                          method:(HttpMethod)method
                         success:(HttpSuccessBlock)success
                          failed:(HttpFailedBlock)failed;
/**
 *  @brief  HTTPS安全请求，将API_HOST中的http://换成https://
 */

- (void)sendSecurityRequestWithURLString:(NSString *)URLString
                              parameters:(id)parameters
                                  method:(HttpMethod)method
                                 success:(HttpSuccessBlock)success
                                  failed:(HttpFailedBlock)failed;

/**
 *  @author licong, 15-11-19 12:11:55
 *
 *  @brief  普通HTTP上传图片,API_HOST是http://开头
 *
 *  @param data      文件大小
 *  @param fileName  文件名,不能为空,服务器没指定,直接填充@"file"
 *  @param name      关联上传数据的名字，不能为空,服务器没指定,直接填充@"file"
 *  @param url       上传地址
 *  @param mineType  文件类型。image/jpg、audio/aac
 *
 *  @since 0.2.2
 */
- (void)sendUploadTaskRequestWithData:(NSData *)data
                             fileName:(NSString *)fileName
                                 name:(NSString*)name
                                  url:(NSString*)url
                             mineType:(NSString *)mineType
                           parameters:(NSDictionary *)parameters
                              success:(HttpSuccessBlock)success
                               failed:(HttpFailedBlock)failed;

/**
 *  @brief  HTTPS安全上传请求，API_HOST是https://开头
 */
- (void)sendSecurityUploadTaskRequestWithData:(NSData *)data
                                     fileName:(NSString *)fileName
                                         name:(NSString*)name
                                          url:(NSString*)url
                                     mineType:(NSString *)mineType
                                   parameters:(NSDictionary *)parameters
                                      success:(HttpSuccessBlock)success
                                       failed:(HttpFailedBlock)failed;

@end

