//
//  OCEmptyView.h
//  Gengmei
//
//  Created by wangyang on 16/7/9.
//  Copyright © 2016年 更美互动信息科技有限公司. All rights reserved.
//

#import <UIKit/UIKit.h>

typedef NS_ENUM(NSUInteger, OCEmptyViewType) {
    OCEmptyViewTypeEmpty,
    OCEmptyViewTypeException
};

@protocol OCEmptyViewDelegate <NSObject>

- (void)emptyViewDidClickReload;

@end

@interface OCEmptyView : UIView
@property (nonatomic, strong) UIImageView *tipIcon;
@property (nonatomic, strong) UILabel *tipLabel;
@property (nonatomic, strong) UIButton *tipButton;
@property (nonatomic, assign) OCEmptyViewType type;
@property (nonatomic, weak) id<OCEmptyViewDelegate> delegate;
@property (nonatomic, copy) NSString *emptyImage;
@property (nonatomic, copy) NSString *emptyText;
@property (nonatomic, copy) NSString *exceptionImage;
@property (nonatomic, copy) NSString *exceptionText;

@end
