//
//  UIViewController+HUD.m
//  Pods
//
//  Created by wangyang on 16/7/11.
//
//

#import "UIViewController+HUD.h"
#import <objc/runtime.h>

@interface UIViewController (HUD)
@property (nonatomic, strong) MBProgressHUD *hud;
@end

@implementation UIViewController (HUD)
- (MBProgressHUD *)hud {
    return objc_getAssociatedObject(self, @selector(hud));
}

- (void)setHud:(MBProgressHUD *)hud {
    objc_setAssociatedObject(self, @selector(hud), hud, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}

- (NSTimeInterval)timeForHUDString:(NSString *)string {
    NSInteger count = string.length;
    if (count < 8) {
        return 1.0;
    }else if (count >= 8 && count < 15) {
        return 2;
    } else if (count >= 15 && count < 25) {
        return 3;
    } else {
        return 4;
    }
}

- (void)showComplete:(NSString *)text
{
    [self hideLoading];
    self.hud = [[MBProgressHUD alloc] initWithView:self.view];
    [self.view addSubview:self.hud];
    self.hud.customView = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"ToastFinish"]];
    self.hud.mode = MBProgressHUDModeCustomView;
    self.hud.removeFromSuperViewOnHide = YES;

    self.hud.delegate = self;
    if (text!=nil && text.length>20) {
        self.hud.detailsLabelText = text;
    }else{
        self.hud.labelText = text;
    }
    [self.hud show:YES];
    NSTimeInterval timeInterval = [self timeForHUDString:text];
    [self.hud hide:YES afterDelay:timeInterval];
}

- (void)showWarning:(NSString *)text
{
    [self hideLoading];
    self.hud = [[MBProgressHUD alloc] initWithView:self.view];
    [self.view addSubview:self.hud];
    self.hud.removeFromSuperViewOnHide = YES;

    self.hud.customView = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"ToastWarn"]];
    // Set custom view mode
    self.hud.mode = MBProgressHUDModeCustomView;
    self.hud.delegate = self;
    if (text!=nil && text.length>20) {
        self.hud.detailsLabelText = text;
    }else{
        self.hud.labelText = text;
    }
    [self.hud show:YES];
    NSTimeInterval timeInterval = [self timeForHUDString:text];
    [self.hud hide:YES afterDelay:timeInterval];
}

- (void)showLoading:(NSString *)text
{
    [self hideLoading];
    self.hud = [[MBProgressHUD alloc] initWithView:self.view];
    [self.view addSubview:self.hud];
    self.hud.removeFromSuperViewOnHide = YES;

    self.hud.mode = MBProgressHUDModeIndeterminate;
    self.hud.delegate = self;
    self.hud.labelText = text;
    [self.hud show:YES];

    UIButton *button = [[self valueForKey:@"navigationBar"] valueForKey:@"rightButton"];
    button.enabled = NO;
}

- (void)toast:(NSString *)text{
    [self hideLoading];

    if (text.length == 0) {
        return;
    }

    MBProgressHUD *hud = [MBProgressHUD showHUDAddedTo:[UIApplication sharedApplication].keyWindow animated:YES];
    hud.mode = MBProgressHUDModeText;
    hud.userInteractionEnabled = YES;
    if (text!=nil && text.length>18) {
        hud.detailsLabelText = text;
    }else{
        hud.labelText = text;
    }
    hud.margin = 10.f;
    hud.removeFromSuperViewOnHide = YES;
    NSTimeInterval timeInterval = [self timeForHUDString:text];
    [hud hide:YES afterDelay:timeInterval];
}

- (void)toastInView:(NSString *)text{
    if (text.length == 0) {
        return;
    }
    [self hideLoading];
    MBProgressHUD *hud = [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    hud.mode = MBProgressHUDModeText;
    hud.userInteractionEnabled = YES;
    if (text!=nil && text.length>18) {
        hud.detailsLabelText = text;
    }else{
        hud.labelText = text;
    }
    hud.margin = 10.f;
    hud.removeFromSuperViewOnHide = YES;
    [hud hide:YES afterDelay:1.0];
}

- (void)hideLoading
{
    [self.hud hide:YES];
    UIButton *button = [[self valueForKey:@"navigationBar"] valueForKey:@"rightButton"];
    button.enabled = YES;
}
@end
