//
//  WMBaseViewController.h
//  Gengmei
//
//  Created by 老邢Thierry on 13-9-27. Maintain by iOS Team Member. Rewrite by 汪洋 in 2016-7-8.
//  Copyright (c) 2014 Wanmeichuangyi. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "OCNavigationBar.h"
#import <GMPhobos/GMPhobos-umbrella.h>
@import GMKit;

@interface WMBaseViewController : UIViewController <OCNavigationBarDelegate, GMEmptyViewDelegate>
@property (nonatomic, strong) OCNavigationBar *navigationBar;
/**
 默认值为NO，表示导航栏自动被WMBaseViewController管理，永远在所有的view最上方。
 设置为YES时表示因为特殊需求，开发人员需要自己控制导航，并且需要在viewDidLoad中确定navigationBar的位置
 */
@property (nonatomic, assign) BOOL controlNavigationByYou;

@property (nonatomic, strong) GMEmptyView *emptyView;
/**
 *  @brief  因为controller会有initWithCoder，init，initWithNib三种方式，为了避免子类代码的疏忽导致父类自定义init内容没有覆盖到，所以统一使用initController方法。需要调用super
 */
- (void)initController __attribute__((objc_requires_super));
- (void)pushViewController:(UIViewController *)controller;


#pragma mark - Empty

- (void)showEmptyView:(GMEmptyViewType)type;
- (void)hideEmptyView;
- (void)setupEmptyView;
- (void)emptyViewDidClickReload;
@end
