//
//  GMWelfareServiceObject.h
//  GMBase
//
//  Created by 卢悦明 on 2020/5/12.
//
#import <GMBase/GMObject.h>
#import "GMWelfareVideObject.h"
typedef NS_ENUM(NSUInteger, GMWelfareDetailServiceType) {
    GMWelfareDetailServiceTypeDefault       = 1,// 其他(后端也不知道1, 2啥意思, 旗舰店之前客户端没用到)
    GMWelfareDetailServiceTypeFlagShip      = 3,// 旗舰店(新加类型)
};
NS_ASSUME_NONNULL_BEGIN
@protocol GMWelfareServiceObject @end
@interface GMWelfareServiceObject : GMObject
@property (nonatomic, strong) NSString *serviceId;
@property (nonatomic, strong) NSString *serviceName;
@property (nonatomic, strong) NSString *shortDescription;
@property (nonatomic, strong) NSString *doctorName;
@property (nonatomic, assign) BOOL doctorRecommend;
@property (nonatomic, strong) NSString *pic;
@property (nonatomic, strong) NSString *picSmall;
/** 划线价(7745开始，未选中sku时，会传一个价格区间）, 不需要展示的，original_price会传空字符串 */
@property (nonatomic, strong) NSString *originalPrice;
@property (nonatomic, strong) NSString *gengmeiPrice;
@property (nonatomic, strong) NSString *picNum;
@property (nonatomic, assign) NSInteger sellAmount;
@property (nonatomic, strong) NSString *city;
@property (nonatomic, strong) NSString *url;
@property (nonatomic, strong) NSString *specialInfo;
@property (nonatomic, strong) NSString *specialId;
@property (nonatomic, strong) NSString *specialInfoUrl;
@property (nonatomic, assign) NSInteger saleLimit;
@property (nonatomic, strong) NSNumber *commentRate;
@property (nonatomic, strong) NSArray <GMWelfareVideObject> *headerPic;
@property (nonatomic, strong) NSString *distance;
/** 添加提问按钮 的列表问题  从AI过来的时候， 会有这个字段  by add 7.22.0*/
@property (nonatomic, copy) NSString *projectTag;
/** 美购类型, 先判断旗舰店, 否则就是其他 */
@property (nonatomic, assign) GMWelfareDetailServiceType serviceType;
@property (nonatomic, copy) NSString *image;
@end

NS_ASSUME_NONNULL_END
