//
//  GMNavigationController.m
//  Gengmei
//
//  Created by Terminator on 2017/8/30.
//  Copyright © 2017年 更美互动信息科技有限公司. All rights reserved.
//

#import "GMNavigationController.h"
#import "UIViewController+PushType.h"
#import "GMPresentAnimation.h"
#import "GMCustomNavigationAnimationProtocol.h"
@import GMKit;

@interface GMNavigationController ()<UINavigationControllerDelegate>

@end

@implementation GMNavigationController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.delegate = self;
//    self.fd_viewControllerBasedNavigationBarAppearanceEnabled = NO;
}

- (nullable id <UIViewControllerAnimatedTransitioning>)navigationController:(UINavigationController *)navigationController
                                            animationControllerForOperation:(UINavigationControllerOperation)operation
                                                         fromViewController:(UIViewController *)fromVC
                                                           toViewController:(UIViewController *)toVC {
    if (operation == UINavigationControllerOperationPush && [toVC conformsToProtocol:@protocol(GMCustomNavigationAnimationProtocol)]) {
        id<GMCustomNavigationAnimationProtocol> controller = (id<GMCustomNavigationAnimationProtocol>)toVC;
        id<GMControllerAnimatedTransitioning> animation = controller.navigationAnimation;
        animation.transitionType = operation;
        return animation;
    } else if (operation == UINavigationControllerOperationPop && [fromVC conformsToProtocol:@protocol(GMCustomNavigationAnimationProtocol)] ) {
        id<GMCustomNavigationAnimationProtocol> controller = (id<GMCustomNavigationAnimationProtocol>)fromVC;
        id<GMControllerAnimatedTransitioning> animation = controller.navigationAnimation;
        animation.transitionType = operation;
        return animation;
    }

    return nil;
}

// 依据supportedInterfaceOrientations文档，控制旋转的代码需要写在root view controller，或者全屏的presenting controller
// app的root view controller就是这个GMNavigationController，所以相关控制代码在这里。
- (BOOL)shouldAutorotate {
    return NO;
}

- (UIInterfaceOrientationMask)supportedInterfaceOrientations {
    return UIInterfaceOrientationMaskPortrait;
}
@end
