//
//  UIView+NavigationShadow.m
//  GMBase
//
//  Created by wangyang on 2018/2/23.
//

#import "UIView+NavigationShadow.h"
@import GMKit;
#import <objc/runtime.h>

@interface UIView ()
//@property (nonatomic, strong) UIView *shadowLayer;
@property (nonatomic, strong) CALayer *shadowLayer;
@end

@implementation UIView (NavigationShadow)
- (void)addNavigationShadow {
    self.layer.masksToBounds = NO;
//    self.layer.shadowOpacity = 1.0f;
//    self.layer.shadowRadius = 2.0f;
//    self.layer.shadowOffset = CGSizeMake(0.0, ONE_PIXEL);
//    self.isShowShadow = YES;
//    self.hideTopShadow = YES;

//    UIView *view = [[UIView alloc] initWithFrame:CGRectMake(0, self.bounds.size.height - 12, Constant.screenWidth, 12)];
//    view.backgroundColor = [UIColor whiteColor];
//    view.autoresizingMask = UIViewAutoresizingFlexibleTopMargin;
//    [self addSubview:view];
//    [self sendSubviewToBack:view];
//    view.layer.masksToBounds = NO;
//    view.layer.shadowOpacity = 1.0f;
//    view.layer.shadowRadius = 2.0f;
//    view.layer.shadowOffset = CGSizeMake(0.0, ONE_PIXEL);
//    //view.isShowShadow = YES;
//    view.layer.shadowColor = [UIColor colorWithWhite:0 alpha:0.1].CGColor;

    self.shadowLayer = [CALayer layer];
    self.shadowLayer.bounds = CGRectMake(0, 0, Constant.screenWidth, 12);
    self.shadowLayer.position = CGPointMake(self.bounds.size.width/2, self.bounds.size.height - 6);
    self.shadowLayer.backgroundColor = [UIColor whiteColor].CGColor;
    [self.layer insertSublayer:self.shadowLayer atIndex:0];
    self.shadowLayer.masksToBounds = NO;
    self.shadowLayer.shadowOpacity = 1.0f;
    self.shadowLayer.shadowRadius = 2.0f;
    self.shadowLayer.shadowOffset = CGSizeMake(0.0, ONE_PIXEL);
    self.isShowShadow = YES;
    self.shadowLayer.shadowPath = CGPathCreateWithRect(CGRectMake(0, self.shadowLayer.bounds.size.height - 6, Constant.screenWidth, 6), nil);
}

- (void)setIsShowShadow:(BOOL)isShowShadow {
    objc_setAssociatedObject(self, @selector(isShowShadow), @(isShowShadow), OBJC_ASSOCIATION_RETAIN_NONATOMIC);
    if (isShowShadow) {
        self.shadowLayer.shadowColor = [UIColor colorWithWhite:0 alpha:0.1].CGColor;
    } else {
        self.shadowLayer.shadowColor = [UIColor clearColor].CGColor;
        [self.shadowLayer removeFromSuperlayer];
    }
}

- (BOOL)isShowShadow {
    NSNumber *_isShowShadow = objc_getAssociatedObject(self, @selector(isShowShadow));
    if (_isShowShadow == nil) {
        return 0;
    } else {
        return [_isShowShadow boolValue];
    }
}

- (void)setShadowLayer:(CALayer *)shadowLayer {
    objc_setAssociatedObject(self, @selector(shadowLayer), shadowLayer, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}
- (CALayer *)shadowLayer {
    CALayer *_shadowLayer = objc_getAssociatedObject(self, @selector(shadowLayer));
    if (_shadowLayer == nil) {
        return [CALayer new];
    } else {
        return _shadowLayer;
    }
}

@end
